package com.bxm.localnews.market.service;

import com.bxm.localnews.market.model.dto.KfcOrderDTO;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 千猪kfc订单拉取服务
 *
 * @author wzy
 * @date 2020/8/13 13:58
 **/
public interface KfcOrderAcquireService {
    /**
     * 获取第三方订单列表
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return 第三方订单列表
     */
    List<KfcOrderDTO.Order> getThirdPartyOrder(LocalDateTime startTime,
                                               LocalDateTime endTime);

    /**
     * 处理第三方订单
     *
     * @param thirdPartyOrder 第三方订单对象
     * @param push            是否推送消息并增加用户省钱金额
     * @param increase        是否增加省钱金额开关
     */
    void handleThirdPartyOrder(KfcOrderDTO.Order thirdPartyOrder,
                               boolean push, boolean increase);

    /**
     * 将通过时间范围查找的历史订单保存到数据库
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     */
    void saveKfcOrderByTimeRange(String startTime,
                                 String endTime);
}
