package com.bxm.localnews.market.service;

import com.bxm.localnews.market.model.dto.ExchangeRecordDTO;
import com.bxm.localnews.market.model.dto.ExchangeRoundInfoDTO;
import com.bxm.localnews.market.model.dto.MarketCommodityDTO;
import com.bxm.localnews.market.model.param.ExchangeCommodityParam;
import com.bxm.localnews.market.model.param.ExchangeRecordParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageParam;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * 小红花商城服务
 *
 * @author Dong_hy
 */
public interface MarketService {

    /**
     * 获取所有商品列表
     *
     * @param pageParam 查询参数-分页参数
     * @return 查询结果
     */
    PageWarper<MarketCommodityDTO> getAllCommodityList(PageParam pageParam);

    /**
     * 获取兑换记录信息
     *
     * @param param 兑换记录查询参数
     * @return 查询结果
     */
    PageWarper<ExchangeRecordDTO> getExchangeRecordInfo(ExchangeRecordParam param);

    /**
     * 兑换商品
     *
     * @param param
     * @param devcId
     * @param ip
     * @return
     */
    Message exchangeCommodity(ExchangeCommodityParam param, String devcId, String ip);

    /**
     * 轮播信息
     *
     * @return
     */
    List<ExchangeRoundInfoDTO> queryExchangeRound();
}
