package com.bxm.localnews.market.service;

import com.bxm.localnews.market.model.dto.OilGroupOrderDTO;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 团油第三方订单拉取服务
 *
 * @author wzy
 * @date 2020/8/13 13:58
 **/
public interface OilGroupOrderAcquireService {

    /**
     * 获取订单数据（获取十分钟内的订单数据）
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @param phone     电话号码
     * @return 订单数据列表
     */
    List<OilGroupOrderDTO.Order> getThirdPartyOrder(LocalDateTime startTime, LocalDateTime endTime,
                                                    String phone);

    /**
     * 对拉取的订单进行处理
     *
     * @param thirdPartyOrder 订单对象
     * @param startTime       开始时间
     * @param endTime         结束时间
     * @param push            是否推送省钱消息并增加省钱金额
     * @param increase        是否增加省钱金额
     * @param sensitive       传入的是否是脱敏的手机号码
     */
    void handleThirdPartyOrder(OilGroupOrderDTO.Order thirdPartyOrder, LocalDateTime startTime,
                               LocalDateTime endTime, boolean push, boolean increase, boolean sensitive);

    /**
     * 将通过时间范围查找的历史订单保存到数据库
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     */
    void saveOilOrderByTimeRange(String startTime,
                                 String endTime);
}
