package com.bxm.localnews.market.service;

import com.bxm.localnews.market.dto.CommissionPlatformFacadeDTO;
import com.bxm.localnews.market.dto.UserTbkInfo;
import com.bxm.localnews.market.dto.CommissionPlatformFacadeDTO;
import com.bxm.localnews.market.dto.UserTbkInfo;
import com.bxm.localnews.market.model.entity.OrderInfo;
import com.bxm.localnews.market.model.entity.OrderInfoForQuartz;

import java.math.BigDecimal;

/**
 * 购物订单订单佣金服务
 * @author Gonzo
 * @date  2020-05-07 16:05
 * @since 2.0.0
 */
public interface OrderCommissionService {

    /**
     * 添加购物订单的佣金收益
     * @param orderInfo 购物订单信息
     * @param userTbkInfo 用户信息
     * @param commissionPlatformFacadeDTO 佣金信息
     * @return 是否添加成功
     */
    boolean addCommission(OrderInfo orderInfo, UserTbkInfo userTbkInfo,
                          CommissionPlatformFacadeDTO commissionPlatformFacadeDTO);

    /**
     *
     * @param orderInfo 订单信息
     * @param commissionRate 佣金比例
     * @param userId 用户id
     * @param isPurchaseBySelf 是否自购
     * @return
     */
    boolean addTakeOutOrderCommission(OrderInfo orderInfo, BigDecimal commissionRate,
                                      Long userId, boolean isPurchaseBySelf);

    /**
     * 更新失效订单的佣金
     * @param orderSn
     */
    void updateInvalidOrderCommission(String orderSn);

    /**
     * 定时返佣
     */
    void payCashForLastMonthOrder(OrderInfoForQuartz orderInfo);

    /**
     * 外卖定时返佣
     * @param orderInfo 外卖订单信息
     */
    void payCashForLastMonthTakeOutOrder(OrderInfo orderInfo);
}
