package com.bxm.localnews.market.service;

import com.bxm.component.tbk.order.model.enums.OrderStatusEnum;
import com.bxm.localnews.market.domain.OrderInfoMapper;
import com.bxm.localnews.market.model.dto.BuyMerchantOrderDTO;
import com.bxm.localnews.market.model.entity.OrderInfo;
import com.bxm.newidea.component.tools.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.bxm.localnews.market.model.vo.VerificationCodeVO;

import java.util.Objects;

/**
 * @author wzy
 * @date 2020年09月03日11:57:55
 */
public interface OrderInfoService {
    /**
     * 获取核销码信息通过订单编号
     *
     * @param orderNo 订单编号
     * @return 核销码信息
     */
    VerificationCodeVO getVerificationCodeByOrderNo(String orderNo);


    /**
     * 根据订单id获取信息
     * @param orderId ： 订单id
     * @return
     */
    OrderInfo getSomeInfoById(Long orderId);
}
