package com.bxm.localnews.market.service;

import com.bxm.localnews.market.model.dto.CardCouponOrderDTO;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 365淘券订单拉取服务
 *
 * @author wzy
 * @date 2020/8/13 13:59
 **/
public interface TaoQuanOrderAcquireService {
    /**
     * 获取第三方订单数据
     *
     * @return 第三方订单数据列表
     */
    List<CardCouponOrderDTO.Order> getThirdPartyOrder(LocalDateTime startTime,
                                                      LocalDateTime endTime);

    /**
     * 处理第三方接口拉取的365卡券订单
     *
     * @param thirdPartyOrder 第三方订单对象
     * @param push            是否推送并增加用户省钱金额
     * @param increase        是否增加省钱金额
     */
    void handleThirdPartyOrder(CardCouponOrderDTO.Order thirdPartyOrder,
                               boolean push, boolean increase);

    /**
     * 将通过时间范围查找的历史订单保存到数据库
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     */
    void saveTaoQuanOrderByTimeRange(String startTime,
                                     String endTime);
}
