package com.bxm.localnews.market.service;

import com.bxm.localnews.market.model.dto.BuyMerchantOrderDTO;
import com.bxm.localnews.market.model.dto.UserBuyGoodsOrderDTO;
import com.bxm.localnews.market.model.dto.UserGoodsOrderDTO;
import com.bxm.localnews.market.model.param.*;
import com.bxm.localnews.market.model.param.order.UserBuyGoodsOrderParam;
import com.bxm.localnews.market.model.vo.*;

import java.util.List;

/**
 * 用户订单Service
 */
public interface UserOrderService {
    /**
     * 根据请求参数分页获取用户订单
     *
     * @param param 查询用户订单
     * @return 用户订单列表
     */
    List<UserOrderInfoVO> queryCommodityList(UserOrderParam param);

    /**
     * 查询我的订单
     *
     * @param param 我的订单查询入参
     * @return 我的订单列表
     */
    List<MyOrderInfoVO> queryMyOrderList(MyOrderParam param);


    /**
     * 查询团队订单列表
     *
     * @param param 团队订单查询入参
     * @return 团队订单列表
     */
    List<GroupOrderInfoVO> queryGroupOrderList(GroupOrderParam param);


    /**
     * 根据用户id和订单id查询团油订单详情
     *
     * @param orderSn 订单id
     * @param userId  用户id
     * @return 团油订单详情
     */
    OilGroupOrderDetailVO queryOilGroupOrderDetail(String orderSn, Long userId);


    /**
     * 查询用户订单下每种订单状态订单的数量
     *
     * @param userId 用户id
     * @return 订单状态对应订单数量信息List
     */
    List<OrderStatusCountVO> queryOrderStatusCountList(Long userId);


    /**
     * 站外获取该商品的订单数量（付款且未退款成功）
     * 0代表没有订单
     *
     * @param param 请求参数
     * @return 订单数量
     */
    int getGoodsOrdersByUid(GetGoodsOrdersParam param);

    /**
     * 站外获取该商品的订单信息（付款且未退款成功）
     * 返回已付款且未退款成功、已核销订单
     *
     * @param param 请求参数
     * @return 订单列表
     */
    List<UserGoodsOrderDTO> getGoodsOrdersList(GetGoodsOrdersListParam param);

    /**
     * 根据核销码查询订单信息
     *
     * @param verification : 核销码
     * @param merchantId : 商家id
     * @return : 订单信息
     */
    BuyMerchantOrderDTO getOrderInfoByVerification(Long verification,Long merchantId);

    /**
     * 创建用户订单订单
     *
     * @param param
     * @return ： 订单信息
     */
    UserBuyGoodsOrderDTO createGoodsOrder(UserBuyGoodsOrderParam param);

    /**
     * 订单退单
     * @param orderNo : 订单号
     * @return
     */
    Boolean refundOrder(String orderNo);
}
