package com.bxm.localnews.market.service.order;

import com.bxm.component.tbk.order.service.impl.AbstractOrderCommissionSettleService;
import com.bxm.localnews.market.domain.OrderInfoExtendMapper;
import com.bxm.localnews.market.model.entity.OrderInfoForQuartz;
import com.bxm.localnews.market.service.OrderCommissionService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 购物订单返佣
 * @author Gonzo
 * @date  2020-05-06 10:42
 * @since 3.2.0
 */
@Slf4j
@Service
public class OrderCommissionSettleServiceImpl extends AbstractOrderCommissionSettleService {

    @Autowired
    private OrderInfoExtendMapper orderInfoExtendMapper;

    @Autowired
    private OrderCommissionService orderCommissionService;


    @Override
    protected void doPayCashForLastMonthOrder() {
        // 查询数据库获取购物订单返佣
        List<OrderInfoForQuartz> list = orderInfoExtendMapper.getLastMonthInfo();

        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(orderCommissionService::payCashForLastMonthOrder);
        }
    }
}
