/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.service.order;

import com.bxm.localnews.market.domain.OrderInfoMapper;
import com.bxm.localnews.market.integration.MerchantGoodsIntegrationService;
import com.bxm.localnews.market.model.entity.OrderInfo;
import com.bxm.localnews.market.model.enums.OrderTypeEnum;
import com.bxm.localnews.market.model.vo.MerchantInfoSimpleVO;
import com.bxm.localnews.market.model.vo.VerificationCodeVO;
import com.bxm.localnews.market.service.OrderInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 订单相关service
 *
 * @author jieliGG
 * @date 2020/9/2 22:12
 **/
@Slf4j
@Service
public class OrderInfoServiceImpl implements OrderInfoService {

    @Autowired
    private OrderInfoMapper orderInfoMapper;
    @Autowired
    private MerchantGoodsIntegrationService merchantGoodsIntegrationService;

    /**
     * 根据订单号获取订单信息
     *
     * @param orderNo ： 订单号
     * @return ： 处理后的信息
     */
    @Override
    public VerificationCodeVO getVerificationCodeByOrderNo(String orderNo) {
        OrderInfo orderInfo = orderInfoMapper.selectByOrderSnAndOrderType(orderNo, OrderTypeEnum.WANSHITONG_ONE.getCode());
        // 获取商家信息
        return convertToDto(orderInfo);
    }
    private VerificationCodeVO convertToDto(OrderInfo orderInfo) {
        if (null == orderInfo) {
            return new VerificationCodeVO();
        }
        VerificationCodeVO result = new VerificationCodeVO();
        // 设置核销码
        result.setVerificationCode(String.valueOf(orderInfo.getVerificationCode()));
        // 商品名称
        result.setGoodsName(orderInfo.getGoodsName());
        // 设置订单状态
        result.setState(orderInfo.getOrderStatus());

        MerchantInfoSimpleVO merchantInfoSimpleInfo = merchantGoodsIntegrationService.getMerchantInfoSimpleInfo(Long.valueOf(orderInfo.getGoodsId()));
        log.info("简易商户信息：{}", String.valueOf(merchantInfoSimpleInfo));
        result.setAddress(merchantInfoSimpleInfo.getAddress());
        result.setPhone(merchantInfoSimpleInfo.getMobile());

        return result;
    }
    /**
     * @param orderId : 订单id
     * @return
     */
    @Override
    public OrderInfo getSomeInfoById(Long orderId){
        if(log.isDebugEnabled()){
            log.debug("orderId : {}",orderId);
        }
        OrderInfo result = orderInfoMapper.getSomeInfoById(orderId);

        if(log.isDebugEnabled()){
            log.debug("result : {}",result);
        }
        return result;
    }




//  下面可能用到，暂时保留吧，等接口都ok了删掉它
//    public BuyMerchantOrderDTO getByOrderNo(String orderNo){
//        OrderInfo orderInfo = orderInfoMapper.selectByOrderSnAndOrderType(orderNo, null);
//        return convertToDto(orderInfo);
//    }
//
//
//    private BuyMerchantOrderDTO convertToDto(OrderInfo orderInfo){
//        if(null == orderInfo){
//            return new BuyMerchantOrderDTO();
//        }
//        BuyMerchantOrderDTO result = new BuyMerchantOrderDTO();
//        result.setPayPrice(orderInfo.getPayPrice());
//        result.setEarnMoney(orderInfo.getVipPurchaseCommission());
//        result.setVerificationCode(String.valueOf(orderInfo.getVerificationCode()));
//
//        if(Objects.equals(orderInfo.getOrderStatus(), OrderStatusEnum.SUCCESS_PAY.getStatus())){
//            result.setVerificationState(1);
//        }else if(Objects.equals(orderInfo.getOrderStatus(), OrderStatusEnum.VERIFICATION_PAY.getStatus())){
//            result.setVerificationState(0);
//        }else {
//            //其他状态就默认为错误，这里得仔细看下哦~~~~~~~！！！！
//            result.setVerificationState(2);
//        }
//        result.setOrderNo(orderInfo.getOrderSn());
//        result.setCreateTime(DateUtils.formatDateTime(orderInfo.getCreateTime()));
//        result.setPayTime(DateUtils.formatDateTime(orderInfo.getCreateTime()));
//        result.setName(orderInfo.getOwnerUserName());
//        result.setPhone(orderInfo.getOwnerUserPhone());
//        result.setGoodsName(orderInfo.getGoodsName());
//        result.setGoodsImg(orderInfo.getImgUrl());
//        result.setNum(orderInfo.getGoodsNum().intValue());
//        result.setVipPrice(orderInfo.getVipPurchaseCommission());
//        result.setTotalPrice(orderInfo.getPayPrice());
//        result.setOrderType(orderInfo.getOrderType());
//
//
//        return result;
//    }
}
