package com.bxm.localnews.market.service.order;

import com.bxm.component.tbk.order.model.enums.OrderStatusEnum;
import com.bxm.component.tbk.order.model.enums.TakeOutOrderSource;
import com.bxm.component.tbk.order.service.impl.AbstractTakeOutOrderCommissionService;
import com.bxm.localnews.market.domain.OrderInfoExtendMapper;
import com.bxm.localnews.market.model.entity.OrderInfo;
import com.bxm.localnews.market.service.OrderCommissionService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 外卖订单结算
 * @author Gonzo
 * @date  2020-05-06 10:44
 * @since 2.0.0
 */
@Slf4j
@Service
public class TakeOutOrderCommissionServiceImpl extends AbstractTakeOutOrderCommissionService {

    @Autowired
    private OrderCommissionService orderCommissionService;

    @Autowired
    private OrderInfoExtendMapper orderInfoExtendMapper;

    @Override
    protected void doCommissionSettleByOrderTypeAndTimeBefore(TakeOutOrderSource source, Date timeLimit) {
        log.info("外卖订单结算 source: {}, timeLimit: {}", source, timeLimit);

        // 查询指定时间之前，三方结算 本地未结算的订单
        List<OrderInfo> takeOutOrders = orderInfoExtendMapper.selectBySourceAndTimeLimit(source.getDesc(),
                timeLimit, OrderStatusEnum.UNSETTLED.getStatus());

        // 结算
        takeOutOrders.stream().filter(Objects::nonNull).forEach(orderCommissionService::payCashForLastMonthTakeOutOrder);
    }
}
