package com.bxm.localnews.market.service.order;

import com.bxm.localnews.market.model.dto.CardCouponOrderDTO;
import com.bxm.localnews.market.model.dto.KfcOrderDTO;
import com.bxm.localnews.market.model.dto.OilGroupOrderDTO;
import com.bxm.localnews.market.model.enums.KfcOrderStatusEnum;
import com.bxm.localnews.market.model.enums.OilGroupOrderStatusEnum;
import com.bxm.localnews.market.model.enums.Taoquan365OrderStatusEnum;
import com.bxm.localnews.market.service.ThirdPartyOrderMockService;
import com.bxm.localnews.market.service.KfcOrderAcquireService;
import com.bxm.localnews.market.service.OilGroupOrderAcquireService;
import com.bxm.localnews.market.service.TaoQuanOrderAcquireService;
import com.bxm.localnews.market.service.ThirdPartyOrderMockService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

/**
 * 第三方订单mock服务实现类
 *
 * @author wzy
 * @date 2020-08-19 13:44
 **/
@Service
public class ThirdPartyOrderMockServiceImpl implements ThirdPartyOrderMockService {

    private final TaoQuanOrderAcquireService taoQuanOrderAcquireService;

    private final KfcOrderAcquireService kfcOrderAcquireService;

    private final OilGroupOrderAcquireService oilGroupOrderAcquireService;

    private final SequenceCreater sequenceCreater;

    public ThirdPartyOrderMockServiceImpl(TaoQuanOrderAcquireService taoQuanOrderAcquireService,
                                          KfcOrderAcquireService kfcOrderAcquireService,
                                          OilGroupOrderAcquireService oilGroupOrderAcquireService,
                                          SequenceCreater sequenceCreater) {
        this.taoQuanOrderAcquireService = taoQuanOrderAcquireService;
        this.kfcOrderAcquireService = kfcOrderAcquireService;
        this.oilGroupOrderAcquireService = oilGroupOrderAcquireService;
        this.sequenceCreater = sequenceCreater;
    }

    @Override
    public void mockTaoQuanOrder(Long userId) {
        taoQuanOrderAcquireService.handleThirdPartyOrder(getTaoQuanMockOrder(userId), true, true);
    }

    @Override
    public void mockKfcOrder(Long userId) {
        kfcOrderAcquireService.handleThirdPartyOrder(getKfcOrder(userId), true, true);
    }

    @Override
    public void mockOilOrder(String phone) {
        oilGroupOrderAcquireService.handleThirdPartyOrder(getOilMockOrder(phone),
                LocalDateTime.now(), LocalDateTime.now(), true, true, false);
    }

    private OilGroupOrderDTO.Order getOilMockOrder(String phone) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(DateUtils.DATE_TIME_FORMAT);
        OilGroupOrderDTO.Order mockOilGroupOrder = new OilGroupOrderDTO.Order();
        mockOilGroupOrder.setOrderTime(df.format(LocalDateTime.now()));

        mockOilGroupOrder.setAmountPay("25.7");
        mockOilGroupOrder.setOrderId(sequenceCreater.nextStringId());
        mockOilGroupOrder.setOrderStatusName(OilGroupOrderStatusEnum.HAS_PAYMENT.getDescription());
        mockOilGroupOrder.setAmountGun("30.11");
        mockOilGroupOrder.setGasName("杭州加油站");
        mockOilGroupOrder.setOilNo("95#");
        mockOilGroupOrder.setLitre("20");
        mockOilGroupOrder.setPhone(phone);
        return mockOilGroupOrder;
    }

    private CardCouponOrderDTO.Order getTaoQuanMockOrder(Long userId) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(DateUtils.DATE_TIME_FORMAT);
        CardCouponOrderDTO.Order taoQuanMockOrder = new CardCouponOrderDTO.Order();
        taoQuanMockOrder.setSellOrderNo(String.valueOf(sequenceCreater.nextLongId()));
        taoQuanMockOrder.setNickName("mock购买者");
        taoQuanMockOrder.setCommodityName("中杯通用券[mock]" + df.format(LocalDateTime.now()));
        taoQuanMockOrder.setAgentRebate(BigDecimal.ZERO);
        taoQuanMockOrder.setCreateTime(df.format(LocalDateTime.now()));
        taoQuanMockOrder.setDiffBalance(BigDecimal.ZERO);
        taoQuanMockOrder.setOpenid(String.valueOf(userId));
        taoQuanMockOrder.setAmount(BigDecimal.valueOf(23.4));
        taoQuanMockOrder.setOfficialPrice(BigDecimal.valueOf(29.3));
        taoQuanMockOrder.setOrderStatus(Taoquan365OrderStatusEnum.SOLD.name());
        return taoQuanMockOrder;
    }

    private KfcOrderDTO.Order getKfcOrder(Long userId) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(DateUtils.DATE_TIME_FORMAT);
        KfcOrderDTO.Order kfcMockOrder = new KfcOrderDTO.Order();
        kfcMockOrder.setCreateTime(df.format(LocalDateTime.now()));
        kfcMockOrder.setUpdateTime(df.format(LocalDateTime.now()));
        kfcMockOrder.setAmount(BigDecimal.valueOf(23.4));
        kfcMockOrder.setOrderNo(sequenceCreater.nextStringId());
        kfcMockOrder.setStatus(KfcOrderStatusEnum.SUCCESS.getCode());
        kfcMockOrder.setTotalPrice(BigDecimal.valueOf(23.4));
        kfcMockOrder.setPlatformUniqueId(String.valueOf(userId));

        KfcOrderDTO.Order.KfcPlaceOrder kfcPlaceOrder = new KfcOrderDTO.Order.KfcPlaceOrder();
        kfcPlaceOrder.setCityName("杭州");

        List<KfcOrderDTO.Order.KfcPlaceOrder.Item> goodsItems = new ArrayList<>();
        KfcOrderDTO.Order.KfcPlaceOrder.Item item = new KfcOrderDTO.Order.KfcPlaceOrder.Item();
        item.setProductName("中可+黄金鸡块（单独取餐码）[mock]" + df.format(LocalDateTime.now()));
        item.setImageUrl("https://ossimg.qianzhu8.com/movie/coupon/20200529/1590739961107微信图片_202005291552131.jpg");

        goodsItems.add(item);
        kfcPlaceOrder.setItems(goodsItems);
        kfcMockOrder.setKfcPlaceOrder(kfcPlaceOrder);
        return kfcMockOrder;
    }
}
