/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.service.order.usergoods;

import com.bxm.localnews.market.model.dto.UserGoodsParam;
import com.bxm.newidea.component.vo.Message;

/**
 * @author jieliGG
 * @date 2020/8/25 10:31
 * 订单状态接口
 **/
public interface OrderStateService {
    /**
     * 初始化订单
     * @param userGoodsParam ： 订单参数
     * @return
     */
    Message initOrder(UserGoodsParam userGoodsParam);
    /**
     * 未支付订单时，订单为超时
     * @param userGoodsParam
     * @return
     */
    Message unPayOrder(UserGoodsParam userGoodsParam);

    /**
     * 支付成功的时候
     * @param userGoodsParam
     * @return
     */
    Message pay(UserGoodsParam userGoodsParam);

    /**
     * 申请退单
     * @param userGoodsParam
     * @return
     */
    Message refund(UserGoodsParam userGoodsParam);

    /**
     * 拒绝退单的时候
     * @param userGoodsParam
     * @return
     */
    Message notRefund(UserGoodsParam userGoodsParam);

    /**
     * 同意退单
     * @param userGoodsParam
     * @return
     */
    Message yesRefund(UserGoodsParam userGoodsParam);

    /**
     * 核销订单
     * @param userGoodsParam
     * @return
     */
    Message verification(UserGoodsParam userGoodsParam);

    /**
     * 取消订单
     * @param userGoodsParam
     * @return
     */
    Message cancel(UserGoodsParam userGoodsParam);
}
