/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.service.order.usergoods.event;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.market.model.dto.GoodsOrderEventDTO;
import com.bxm.localnews.market.model.enums.GoodsOrderEventEnum;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;

/**
 * @author jieliGG
 * @date 2020/9/2 14:37
 * 商品订单管理
 **/
@Slf4j
@Component
public class GoodsOrderManage {

    private HashMap<GoodsOrderEventEnum,AbstractGoodsOrderEvent> hashMap;


    @Autowired
    public GoodsOrderManage(List<AbstractGoodsOrderEvent> list){
        hashMap = new HashMap<>(8);
        list.forEach(abstractGoodsOrderEvent -> {
            hashMap.put(abstractGoodsOrderEvent.goodsOrderEventEnum(),abstractGoodsOrderEvent);
        });
    }

    /**
     *
     * 订单处理
     * @return 处理结果
     */
    public Message orderProcess(GoodsOrderEventDTO orderEventDTO){
        AbstractGoodsOrderEvent goodsOrderEvent = hashMap.get(orderEventDTO.getGoodsOrderEventEnum());
        if(null == goodsOrderEvent){
            return Message.build(false);
        }

        Message message = goodsOrderEvent.exec(orderEventDTO);
        log.info("订单处理，请求参数: {} 处理结果: {}", JSON.toJSONString(orderEventDTO), message);
        return message;
    }
}
