/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.service.order.usergoods.event.impl;

import com.bxm.localnews.market.domain.OrderInfoMapper;
import com.bxm.localnews.market.integration.MerchantGoodsIntegrationService;
import com.bxm.localnews.market.model.dto.GoodsOrderEventDTO;
import com.bxm.localnews.market.model.enums.GoodsOrderEventEnum;
import com.bxm.localnews.market.service.order.usergoods.event.AbstractGoodsOrderEvent;
import com.bxm.localnews.market.service.order.usergoods.impl.CancelOrderState;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author jieliGG
 * @date 2020/9/1 20:54
 * 新建订单的动作
 **/
@Slf4j
@Component
public class CancelOrderEvent extends AbstractGoodsOrderEvent {

    @Autowired
    private CancelOrderState cancelOrderState;

    @Autowired
    private MerchantGoodsIntegrationService merchantGoodsIntegrationService;

    @Autowired
    protected OrderInfoMapper orderInfoMapper;

    @Override
    protected Message prepare(GoodsOrderEventDTO orderEventDTO) {
        Message message = super.prepare(orderEventDTO);
        if (!message.isSuccess()) {
            return message;
        }
        return Message.build(true);
    }

    @Override
    protected Message handler(GoodsOrderEventDTO orderEventDTO) {
        return cancelOrderState.cancel(getUserGoodsParam(orderEventDTO));
    }

    @Override
    protected void after(GoodsOrderEventDTO orderEventDTO) {

    }

    @Override
    protected void handlerFail(GoodsOrderEventDTO orderEventDTO) {

    }

    @Override
    protected GoodsOrderEventEnum goodsOrderEventEnum() {
        return GoodsOrderEventEnum.UNPAY;
    }

}
