/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.service.order.usergoods.event.impl;

import com.bxm.component.tbk.order.model.enums.OrderStatusEnum;
import com.bxm.localnews.market.domain.OrderInfoMapper;
import com.bxm.localnews.market.integration.MerchantGoodsIntegrationService;
import com.bxm.localnews.market.model.dto.GoodsOrderEventDTO;
import com.bxm.localnews.market.model.dto.PushMessageByOrderDTO;
import com.bxm.localnews.market.model.entity.OrderInfo;
import com.bxm.localnews.market.model.enums.GoodsOrderEventEnum;
import com.bxm.localnews.market.service.OrderPushServiceFactory;
import com.bxm.localnews.market.service.order.usergoods.event.AbstractGoodsOrderEvent;
import com.bxm.localnews.market.service.order.usergoods.impl.InitOrderState;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static java.util.Objects.isNull;

/**
 * @author jieliGG
 * @date 2020/9/1 20:54
 * 新建订单的动作
 **/
@Slf4j
@Component
public class InitOrderEvent extends AbstractGoodsOrderEvent {

    @Autowired
    private InitOrderState initOrderState;

    @Autowired
    private OrderPushServiceFactory orderPushServiceFactory;

    @Autowired
    private MerchantGoodsIntegrationService merchantGoodsIntegrationService;

    @Autowired
    protected OrderInfoMapper orderInfoMapper;

    @Override
    protected Message prepare(GoodsOrderEventDTO orderEventDTO) {
        Message message = super.prepare(orderEventDTO);
        if (!message.isSuccess()) {
            return message;
        }

        // 查看当前用户是否已经下单
        OrderInfo orderInfo = orderInfoMapper.selectLastOrderByGidStatus(orderEventDTO.getGoodsId(), OrderStatusEnum.UNPAY.getStatus(), orderEventDTO.getUserId());
        if (isNull(orderInfo)) {
            // 校验库存
            Boolean result = merchantGoodsIntegrationService.subOrderNum(orderEventDTO.getGoodsId(), orderEventDTO.getNum().intValue());
            if (Boolean.FALSE.equals(result)) {
                return Message.build(false, "库存好像不够了，刷新一下试试吧~");
            }
        } else {
            log.info("用户: {} 已下过商品: {} 订单，不重复扣除库存", orderEventDTO.getUserId(), orderEventDTO.getGoodsId());
            orderEventDTO.setRepeatOrder(true);
        }

        return Message.build(true);
    }

    @Override
    protected Message handler(GoodsOrderEventDTO orderEventDTO) {
        return initOrderState.initOrder(getUserGoodsParam(orderEventDTO));
    }

    @Override
    protected void after(GoodsOrderEventDTO orderEventDTO) {
        if (!orderEventDTO.isRepeatOrder()) {
            PushMessageByOrderDTO orderDTO = getOrderDTO(orderEventDTO);
            orderDTO.setNickname(orderEventDTO.getOrderInfo().getOwnerUserName());
            orderDTO.setOrderStatusEnum(OrderStatusEnum.UNPAY);
            orderPushServiceFactory.pushMessageToMerchantByOrder(orderDTO);
        }
    }

    @Override
    protected void handlerFail(GoodsOrderEventDTO orderEventDTO) {
        merchantGoodsIntegrationService.returnGoodsNum(orderEventDTO.getGoodsId(), orderEventDTO.getNum());
    }

    @Override
    protected GoodsOrderEventEnum goodsOrderEventEnum() {
        return GoodsOrderEventEnum.TO_ORDER;
    }


}
