/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.service.order.usergoods.event.impl;

import com.bxm.localnews.market.model.dto.GoodsOrderEventDTO;
import com.bxm.localnews.market.model.enums.GoodsOrderEventEnum;
import com.bxm.localnews.market.service.OrderPushServiceFactory;
import com.bxm.localnews.market.service.order.usergoods.event.AbstractGoodsOrderEvent;
import com.bxm.localnews.market.service.order.usergoods.impl.UnpayOrderState;
import com.bxm.localnews.market.service.OrderPushServiceFactory;
import com.bxm.localnews.market.service.order.usergoods.event.AbstractGoodsOrderEvent;
import com.bxm.localnews.market.service.order.usergoods.impl.UnpayOrderState;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author jieliGG
 * @date 2020/9/2 11:23
 * 支付失败
 **/
@Component
public class PayFailEvent extends AbstractGoodsOrderEvent {
    @Autowired
    private UnpayOrderState unpayOrderState;
    @Autowired
    private OrderPushServiceFactory orderPushServiceFactory;
    @Override
    protected Message handler(GoodsOrderEventDTO orderEventDTO) {
        return unpayOrderState.unPayOrder(getUserGoodsParam(orderEventDTO));
    }

    @Override
    protected void after(GoodsOrderEventDTO orderEventDTO) {

    }

    @Override
    protected GoodsOrderEventEnum goodsOrderEventEnum() {
        return GoodsOrderEventEnum.UNPAY;
    }
}
