/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.service.order.usergoods.event.impl;

import com.bxm.component.tbk.order.model.enums.OrderStatusEnum;
import com.bxm.localnews.market.model.dto.GoodsOrderEventDTO;
import com.bxm.localnews.market.model.dto.PushMessageByOrderDTO;
import com.bxm.localnews.market.model.enums.GoodsOrderEventEnum;
import com.bxm.localnews.market.service.OrderPushServiceFactory;
import com.bxm.localnews.market.service.order.usergoods.event.AbstractGoodsOrderEvent;
import com.bxm.localnews.market.service.order.usergoods.impl.PaySuccessOrderState;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author jieliGG
 * @date 2020/9/1 21:35
 * 支付成功
 **/
@Component
public class PaySuccessEvent extends AbstractGoodsOrderEvent {
    @Autowired
    private PaySuccessOrderState paySuccessOrderState;
    @Autowired
    private OrderPushServiceFactory orderPushServiceFactory;
    @Override
    protected Message handler(GoodsOrderEventDTO orderEventDTO) {
        return paySuccessOrderState.pay(getUserGoodsParam(orderEventDTO));
    }

    @Override
    protected void after(GoodsOrderEventDTO orderEventDTO) {
        //推送给商户
        PushMessageByOrderDTO orderDTO = getOrderDTO(orderEventDTO);
        orderDTO.setNickname(orderEventDTO.getOrderInfo().getOwnerUserName());
        orderDTO.setGoodsName(orderEventDTO.getOrderInfo().getGoodsName());
        orderDTO.setOrderStatusEnum(OrderStatusEnum.SUCCESS_PAY);
        orderPushServiceFactory.pushMessageToMerchantByOrder(orderDTO);

        //推送给用户
        PushMessageByOrderDTO userOrderDTO = getOrderDTO(orderEventDTO);
        orderDTO.setNickname(orderEventDTO.getOrderInfo().getOwnerUserName());
        userOrderDTO.setPushUserId(orderEventDTO.getOrderInfo().getOwnerUserId());
        userOrderDTO.setOrderStatusEnum(OrderStatusEnum.SUCCESS_PAY);
        userOrderDTO.setGoodsName(orderEventDTO.getOrderInfo().getGoodsName());
        orderPushServiceFactory.pushMessageToUserByOrder(userOrderDTO, orderEventDTO);

        //给用户推短信
        orderPushServiceFactory.buyGoodsSendSms(orderEventDTO.getOrderInfo().getOwnerUserPhone(),
                orderEventDTO.getOrderInfo().getGoodsName(),orderEventDTO.getOrderInfo().getVerificationCode());
    }

    @Override
    protected GoodsOrderEventEnum goodsOrderEventEnum() {
        return GoodsOrderEventEnum.PAY;
    }


}
