/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.service.order.usergoods.event.impl;

import com.bxm.component.tbk.order.model.enums.OrderStatusEnum;
import com.bxm.localnews.market.model.dto.GoodsOrderEventDTO;
import com.bxm.localnews.market.model.dto.PushMessageByOrderDTO;
import com.bxm.localnews.market.model.enums.GoodsOrderEventEnum;
import com.bxm.localnews.market.service.OrderPushServiceFactory;
import com.bxm.localnews.market.service.order.usergoods.event.AbstractGoodsOrderEvent;
import com.bxm.localnews.market.service.order.usergoods.impl.RefundYesOrderState;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author jieliGG
 * @date 2020/9/2 14:30
 * 退单成功事件
 **/
@Component
public class RefundSuccessEvent extends AbstractGoodsOrderEvent {
    @Autowired
    private RefundYesOrderState refundYesOrderState;
    @Autowired
    private OrderPushServiceFactory orderPushServiceFactory;
    @Override
    protected Message handler(GoodsOrderEventDTO orderEventDTO) {
        return refundYesOrderState.yesRefund(getUserGoodsParam(orderEventDTO));
    }

    @Override
    protected void after(GoodsOrderEventDTO orderEventDTO) {
        //用户发送推送-退关到账
        PushMessageByOrderDTO orderDTO = getOrderDTO(orderEventDTO);
        orderDTO.setNickname(orderEventDTO.getOrderInfo().getOwnerUserName());
        orderDTO.setPushUserId(orderEventDTO.getOrderInfo().getOwnerUserId());
        orderDTO.setOrderStatusEnum(OrderStatusEnum.REFUND_SUCCESS);
        orderDTO.setGoodsName(orderEventDTO.getOrderInfo().getGoodsName());
        orderPushServiceFactory.pushMessageToUserByOrder(orderDTO, orderEventDTO);

        //给用户发短信
        orderPushServiceFactory.refundSuccessSendSms(orderEventDTO.getOrderInfo().getOwnerUserPhone(),
                orderEventDTO.getOrderInfo().getPayPrice().add(orderEventDTO.getOrderInfo().getOpenVip()));
    }

    @Override
    protected GoodsOrderEventEnum goodsOrderEventEnum() {
        return GoodsOrderEventEnum.REFUND_YES;
    }
}
