/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.service.order.usergoods.event.impl;

import com.bxm.component.tbk.order.model.enums.OrderStatusEnum;
import com.bxm.localnews.market.domain.OrderInfoMapper;
import com.bxm.localnews.market.integration.MerchantGoodsIntegrationService;
import com.bxm.localnews.market.model.constant.CommonConstant;
import com.bxm.localnews.market.model.dto.GoodsOrderEventDTO;
import com.bxm.localnews.market.model.dto.MerchantGoodsInfoDTO;
import com.bxm.localnews.market.model.dto.PushMessageByOrderDTO;
import com.bxm.localnews.market.model.entity.OrderInfo;
import com.bxm.localnews.market.model.enums.GoodsOrderEventEnum;
import com.bxm.localnews.market.model.enums.OrderTypeEnum;
import com.bxm.localnews.market.service.OrderPushServiceFactory;
import com.bxm.localnews.market.service.order.usergoods.event.AbstractGoodsOrderEvent;
import com.bxm.localnews.market.service.order.usergoods.impl.VerificationOrderState;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @author jieliGG
 * @date 2020/9/2 11:27
 * 核销动作
 **/
@Component
public class VerificationEvent extends AbstractGoodsOrderEvent {
    @Autowired
    private VerificationOrderState verificationOrderState;
    @Autowired
    private OrderPushServiceFactory orderPushServiceFactory;
    @Autowired
    private MerchantGoodsIntegrationService merchantGoodsIntegrationService;
    @Autowired
    private OrderInfoMapper orderInfoMapper;

    @Override
    protected Message prepare(GoodsOrderEventDTO orderEventDTO) {
        Message message = super.prepare(orderEventDTO);
        if (!message.isSuccess()) {
            return message;
        }

        // 获取订单信息
        OrderInfo orderInfo = orderInfoMapper.selectByOrderSnAndOrderType(orderEventDTO.getOrderNo(), OrderTypeEnum.WANSHITONG_ONE.getCode());

        if (Objects.isNull(orderInfo)) {
            return Message.build(false, "订单不存在").addParam(CommonConstant.VERIFICATION_ORDER_STATE,CommonConstant.WRONG);
        }

        if(!Objects.equals(orderInfo.getOrderStatus(),OrderStatusEnum.SUCCESS_PAY.getStatus())){
            return Message.build(false,"订单无法核销").addParam(CommonConstant.VERIFICATION_ORDER_STATE,CommonConstant.FAIL);
        }

        MerchantGoodsInfoDTO merchantGoodsInfoDTO = merchantGoodsIntegrationService.getMerchantGoodsById(Long.parseLong(orderInfo.getGoodsId()));
        if(null == merchantGoodsInfoDTO
                || !Objects.equals(merchantGoodsInfoDTO.getMerchantId(),orderEventDTO.getMerchantId())){
            //不是自己的订单，无法核销
            return Message.build(false, "订单不存在").addParam(CommonConstant.VERIFICATION_ORDER_STATE,CommonConstant.WRONG);
        }

        orderEventDTO.setOrderInfo(orderInfo);
        return Message.build(true);
    }

    @Override
    protected Message handler(GoodsOrderEventDTO orderEventDTO) {
        return verificationOrderState.verification(getUserGoodsParam(orderEventDTO));
    }

    @Override
    protected void after(GoodsOrderEventDTO orderEventDTO) {
        //给商家发推送
        PushMessageByOrderDTO orderDTO = getOrderDTO(orderEventDTO);
        orderDTO.setOrderStatusEnum(OrderStatusEnum.VERIFICATION_PAY);
        orderDTO.setNickname(orderEventDTO.getOrderInfo().getOwnerUserName());
        orderPushServiceFactory.pushMessageToMerchantByOrder(orderDTO);
//
        //给用户发送订单评价的 推送，这个版本【3.6.0】没有评价就先去掉，以后用打开就行了
//        PushMessageByOrderDTO userOrderDTO = new PushMessageByOrderDTO();
//        userOrderDTO.setPushUserId(orderEventDTO.getOrderInfo().getOwnerUserId());
//        userOrderDTO.setOrderStatusEnum(OrderStatusEnum.VERIFICATION_PAY);
//        userOrderDTO.setNickname(orderEventDTO.getOrderInfo().getOwnerUserName());
//        userOrderDTO.setGoodsName(StringUtils.substring(orderEventDTO.getOrderInfo().getGoodsName(),0,5));
//        orderPushServiceFactory.pushMessageToUserByOrder(userOrderDTO, orderEventDTO);


    }




    @Override
    protected GoodsOrderEventEnum goodsOrderEventEnum() {
        return GoodsOrderEventEnum.VERIFICATION;
    }
}
