/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.service.order.usergoods.impl;

import com.bxm.component.tbk.order.model.enums.OrderStatusEnum;
import com.bxm.localnews.enums.MerchantBossAccountActionEnum;
import com.bxm.localnews.market.model.dto.MerchantGoodsInfoDTO;
import com.bxm.localnews.market.model.dto.MerchantOrderInfoDTO;
import com.bxm.localnews.market.model.dto.UserGoodsParam;
import com.bxm.localnews.market.model.entity.OrderInfo;
import com.bxm.localnews.market.model.enums.OrderTypeEnum;
import com.bxm.localnews.market.param.OperatorMerchantAccountParam;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Objects;

import static com.alibaba.fastjson.JSON.toJSONString;
import static com.bxm.localnews.market.model.enums.MerchantOrderStatusEnum.EXPIRED;

/**
 * 取消结算
 *
 * @author jieliGG
 * @date 2020/8/26 22:11
 **/
@Slf4j
@Component
public class CancelOrderState extends AbstractOrderState {

    @Override
    public Message cancel(UserGoodsParam userGoodsParam) {
        OrderInfo orderInfo = orderInfoMapper.selectByOrderSnAndOrderType(userGoodsParam.getOrderNo(), OrderTypeEnum.WANSHITONG_ONE.getCode());
        log.info("取消订单: {}，订单信息: {}", userGoodsParam.getOrderNo(), toJSONString(orderInfo));

        if (Objects.isNull(orderInfo)) {
            return Message.build(false, "订单不存在");
        }

        if (!Objects.equals(orderInfo.getOrderStatus(), OrderStatusEnum.UNPAY.getStatus())) {
            return Message.build(false, StringUtils.join("订单的状态: {}", orderInfo.getOrderStatus(), "不是未支付，无法取消"));
        }

        // 归还库存
        merchantGoodsIntegrationService.returnGoodsNum(Long.parseLong(orderInfo.getGoodsId()), orderInfo.getGoodsNum());

        // 状态修改 -超时未支付
        OrderInfo update = new OrderInfo();
        update.setId(orderInfo.getId());
        update.setOrderStatus(OrderStatusEnum.TIMEOUT_PAY.getStatus());
        orderInfoMapper.updateByPrimaryKeySelective(update);

        MerchantOrderInfoDTO merchantOrder = new MerchantOrderInfoDTO();
        merchantOrder.setOrderNo(userGoodsParam.getOrderNo());
        // 6：订单未支付过期
        merchantOrder.setState(EXPIRED.getStatus());
        merchantGoodsIntegrationService.updateMerchantOrderByNo(merchantOrder);

        //商家金额变更
        changeMerchantAccount(orderInfo);

        return Message.build(true);
    }

    /**
     * 修改商家账户信息
     */
    private void changeMerchantAccount(OrderInfo orderInfo) {

        OperatorMerchantAccountParam accountParam = new OperatorMerchantAccountParam();
        accountParam.setActionEnum(MerchantBossAccountActionEnum.ACCOUNT_ACTION_DRAWBACK);
        accountParam.setPayMoney(orderInfo.getPayPrice());
        accountParam.setServiceMoney(getServiceMoney(orderInfo.getPayPrice()));
        accountParam.setPromotionMoney(orderInfo.getCommission());
        // 商家实际到账金额：支付金额 - 服务费 - 佣金
        accountParam.setReceiveMoney(orderInfo.getPayPrice().subtract(accountParam.getServiceMoney()).subtract(accountParam.getPromotionMoney()));
        accountParam.setGoodsName(orderInfo.getGoodsName());
        accountParam.setOrderSn(orderInfo.getOrderSn());
        accountParam.setRelationId(orderInfo.getId());

        // 获取商家和商品信息
        MerchantGoodsInfoDTO merchantGoodsInfoDTO = merchantGoodsIntegrationService.getMerchantGoodsById(Long.parseLong(orderInfo.getGoodsId()));
        accountParam.setMerchantId(merchantGoodsInfoDTO.getMerchantId());
        merchantGoodsIntegrationService.operatorMerchantAccount(accountParam);
    }

}
