/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.service.order.usergoods.impl;

import com.bxm.component.tbk.order.model.enums.OrderStatusEnum;
import com.bxm.localnews.common.util.NidGeneratorUtil;
import com.bxm.localnews.constants.RedisConfig;
import com.bxm.localnews.enums.MerchantBossAccountActionEnum;
import com.bxm.localnews.market.domain.OrderInfoMapper;
import com.bxm.localnews.market.domain.OrderProfitExtendMapper;
import com.bxm.localnews.market.dto.UserInviteHistoryDTO;
import com.bxm.localnews.market.integration.MerchantGoodsIntegrationService;
import com.bxm.localnews.market.integration.UserAccountIntegrationService;
import com.bxm.localnews.market.integration.UserIntegrationService;
import com.bxm.localnews.market.integration.UserVipIntegrationService;
import com.bxm.localnews.market.model.constant.CommonConstant;
import com.bxm.localnews.market.model.constant.ProfitTypeConstant;
import com.bxm.localnews.market.model.dto.MerchantGoodsInfoDTO;
import com.bxm.localnews.market.model.dto.MerchantOrderInfoDTO;
import com.bxm.localnews.market.model.dto.UserGoodsParam;
import com.bxm.localnews.market.model.entity.OrderInfo;
import com.bxm.localnews.market.model.entity.OrderProfit;
import com.bxm.localnews.market.model.enums.OrderTypeEnum;
import com.bxm.localnews.market.model.enums.ProfitTypeEnum;
import com.bxm.localnews.market.model.param.ActivationUserVipParam;
import com.bxm.localnews.market.param.CashAccountParam;
import com.bxm.localnews.market.param.OperatorMerchantAccountParam;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

import static com.alibaba.fastjson.JSON.toJSONString;
import static com.bxm.localnews.market.model.enums.MerchantOrderStatusEnum.PAYED;

/**
 * @author jieliGG
 * @date 2020/8/26 21:29
 * 支付成功的状态
 **/
@Component
@Slf4j
@AllArgsConstructor
public class PaySuccessOrderState extends AbstractOrderState {

    private final VerificationOrderState verificationOrderState;

    private final SequenceCreater sequenceCreater;

    private final MerchantGoodsIntegrationService merchantGoodsIntegrationService;

    private final UserIntegrationService userIntegrationService;

    private final RedisStringAdapter redisStringAdapter;

    private final UserVipIntegrationService userVipIntegrationService;

    private final OrderProfitExtendMapper orderProfitExtendMapper;

    private final UserAccountIntegrationService userAccountIntegrationService;

    private final RefundingOrderState refundingOrderState;

    private final OrderInfoMapper orderInfoMapper;

    @Override
    public Message pay(UserGoodsParam userGoodsParam) {
        log.info("收到的商品支付成功回调[{}]", toJSONString(userGoodsParam));

        if (Objects.isNull(userGoodsParam.getOrderInfo())) {
            OrderInfo orderInfo = orderInfoMapper.selectByOrderSnAndOrderType(userGoodsParam.getOrderNo(), OrderTypeEnum.WANSHITONG_ONE.getCode());
            if (null == orderInfo) {
                return Message.build(false, "订单不存在");
            }
            userGoodsParam.setOrderInfo(orderInfo);
        }

        if (!Objects.equals(userGoodsParam.getOrderInfo().getOrderStatus(), OrderStatusEnum.UNPAY.getStatus())) {
            log.info("订单{} 的状态是: {} 不是未支付状态，无法支付成功", userGoodsParam.getOrderInfo().getOrderSn(), userGoodsParam.getOrderInfo().getOrderStatus());
            return Message.build(false);
        }

        //给商户增加冻结中金额  + 增加商家今日总收益金额
        addMerchantAccount(userGoodsParam);

        // 增加佣金
        addInviteCommies(userGoodsParam);

        //更新商家订单信息
        updateMerchantOrder(userGoodsParam);

        //给用户开通VIP
        if (!Objects.equals(userGoodsParam.getOrderInfo().getOpenVip().compareTo(BigDecimal.ZERO), 0)) {
            openVip(userGoodsParam.getOrderInfo().getOwnerUserId(), userGoodsParam.getOrderInfo().getId());
        }

        //修改订单状态
        userGoodsParam.getOrderInfo().setOrderStatus(OrderStatusEnum.SUCCESS_PAY.getStatus());
        orderInfoMapper.updateOrderStatusByOrderSnOrderType(userGoodsParam.getOrderInfo());

        return Message.build(true).addParam(CommonConstant.CREATE_ORDER_INFO_KEY, userGoodsParam.getOrderInfo());
    }

    @Override
    public Message refund(UserGoodsParam userGoodsParam) {
        return refundingOrderState.refund(userGoodsParam);
    }

    @Override
    public Message verification(UserGoodsParam userGoodsParam) {
        return verificationOrderState.verification(userGoodsParam);
    }

    /**
     * 给商家增加金额
     *
     * @param userGoodsParam : 入参
     */
    private void addMerchantAccount(UserGoodsParam userGoodsParam) {

        OrderInfo orderInfo = userGoodsParam.getOrderInfo();
        OperatorMerchantAccountParam accountParam = new OperatorMerchantAccountParam();
        accountParam.setActionEnum(MerchantBossAccountActionEnum.ACCOUNT_ACTION_PAYMENT);
        accountParam.setPayMoney(orderInfo.getPayPrice());
        accountParam.setServiceMoney(getServiceMoney(orderInfo.getPayPrice()));
        accountParam.setPromotionMoney(orderInfo.getCommission());
        //商家实际到账金额：支付金额 - 服务费 - 佣金
        accountParam.setReceiveMoney(orderInfo.getPayPrice().subtract(accountParam.getServiceMoney()).subtract(accountParam.getPromotionMoney()));
        accountParam.setGoodsName(orderInfo.getGoodsName());
        accountParam.setOrderSn(orderInfo.getOrderSn());
        accountParam.setRelationId(orderInfo.getId());
        //获取商家和商品信息
        MerchantGoodsInfoDTO merchantGoodsInfoDTO = merchantGoodsIntegrationService.getMerchantGoodsById(Long.parseLong(orderInfo.getGoodsId()));
        accountParam.setMerchantId(merchantGoodsInfoDTO.getMerchantId());
        log.info("商家订单参数：【{}】", toJSONString(accountParam));
        merchantGoodsIntegrationService.operatorMerchantAccount(accountParam);
    }

    /**
     * 给师傅增加分享佣金
     */
    private void addInviteCommies(UserGoodsParam userGoodsParam) {
        OrderInfo orderInfo = userGoodsParam.getOrderInfo();
        if (Objects.isNull(orderInfo)) {
            log.warn("订单不存在，无法结算");
            return;
        }

        // 给分享人发送奖励
        Long benefitUser = redisStringAdapter.get(RedisConfig.MARKET_RECORD_GOODS_SHARE_USER.copy().appendKey(userGoodsParam.getOrderNo()), Long.class);
        //获取到设置为永久，等到核销成功后再删除
        redisStringAdapter.set(RedisConfig.MARKET_RECORD_GOODS_SHARE_USER.copy().appendKey(orderInfo.getOrderSn()),benefitUser);
        Boolean vip;
        ProfitTypeEnum profitTypeEnum;
        //有分享人信息
        if (Objects.nonNull(benefitUser)) {
            profitTypeEnum = ProfitTypeEnum.SHARE;
        } else {
            benefitUser = userGoodsParam.getOrderInfo().getOwnerUserId();
            profitTypeEnum = ProfitTypeEnum.PURCHASE;
        }
        //分享人或者自购佣金
        if(Objects.equals(userGoodsParam.getOrderInfo().getOpenVip().compareTo(BigDecimal.ZERO),0)){
            vip = userVipIntegrationService.isVip(benefitUser);
        }else{
            //是联合开通VIP的话，直接给true
            vip = true;
        }
        BigDecimal commission = getShareMoney(userGoodsParam.getOrderInfo().getCommission(), vip);
        BigDecimal parentCommission = getMasterMoney(userGoodsParam.getOrderInfo().getCommission(), vip, ProfitTypeEnum.PARENT);
        BigDecimal grandparentCommission = getMasterMoney(userGoodsParam.getOrderInfo().getCommission(), vip, ProfitTypeEnum.GRANDPARENT);

        // 增加佣金订单
        Date now = new Date();
        OrderInfo commissionOrder = new OrderInfo();
        BeanUtils.copyProperties(orderInfo, commissionOrder);
        commissionOrder.setId(sequenceCreater.nextLongId());
        commissionOrder.setCommission(commission);
        // 团购订单号
        commissionOrder.setOrderParentSn(orderInfo.getOrderSn());
        // 当前订单号重新生成
        commissionOrder.setOrderSn(NidGeneratorUtil.getOrderNo(OrderTypeEnum.WST_ONE_COMMI.getCode().toString()));
        commissionOrder.setVipPurchaseCommission(commission);
        commissionOrder.setPurchaseCommission(commission);
        commissionOrder.setParentCommission(parentCommission);
        commissionOrder.setGrandparentCommission(grandparentCommission);
        commissionOrder.setCreateTime(now);
        commissionOrder.setModifyTime(now);
        commissionOrder.setOwnerUserId(benefitUser);
        commissionOrder.setOrderType(OrderTypeEnum.WST_ONE_COMMI.getCode());
        commissionOrder.setSource(OrderTypeEnum.WST_ONE_COMMI.name());
        commissionOrder.setTbOrderType(OrderTypeEnum.WST_ONE_COMMI.getDescription());
        commissionOrder.setOrderStatus(OrderStatusEnum.UNSETTLED.getStatus());
        commissionOrder.setVerificationCode(null);

        // 如果分享人的字段为空说明是自购订单
        commissionOrder.setOrderProfitType(profitTypeEnum.name());

        orderInfoMapper.insertSelective(commissionOrder);

        // 添加自购佣金
        giveProfitUserCommission(benefitUser, vip, profitTypeEnum, commission, commissionOrder);
        userGoodsParam.getOrderInfo().setPurchaseCommission(commission);

        //是否有师傅
        UserInviteHistoryDTO inviteHistoryDTO = userIntegrationService.getInviteInfo(benefitUser);
        log.info("用户: {} 的上级信息: {}", benefitUser, toJSONString(inviteHistoryDTO));

        if (Objects.isNull(inviteHistoryDTO)) {
            return;
        }

        // 给一级师傅奖励
        if (Objects.nonNull(inviteHistoryDTO.getInviteUserId()) && !Objects.equals(inviteHistoryDTO.getInviteUserId(),0)  ) {
            log.info("用户: {} 一级师傅奖励: {}", benefitUser, parentCommission);
            giveProfitUserCommission(inviteHistoryDTO.getInviteUserId(),
                    userVipIntegrationService.isVip(inviteHistoryDTO.getInviteUserId()),
                    ProfitTypeEnum.PARENT, parentCommission, commissionOrder);

            userGoodsParam.getOrderInfo().setParentCommission(parentCommission);
        }

        // 给二级师傅奖励
        if (Objects.nonNull(inviteHistoryDTO.getInviteSuperUserId()) && !Objects.equals(inviteHistoryDTO.getInviteSuperUserId(),0)) {
            log.info("用户: {} 二级师傅奖励: {}", benefitUser, parentCommission);
            giveProfitUserCommission(inviteHistoryDTO.getInviteSuperUserId(),
                    userVipIntegrationService.isVip(inviteHistoryDTO.getInviteSuperUserId()),
                    ProfitTypeEnum.GRANDPARENT, grandparentCommission, commissionOrder);

            userGoodsParam.getOrderInfo().setGrandparentCommission(grandparentCommission);
        }
    }

    /**
     * 给收益人发佣金
     *
     * @param profitUserId : 受益人id
     * @param profitType   ：受益类型
     * @param money        ： 收益金额 : 已经计算过比率的了
     * @param orderInfo    : 用户订单参数
     * @param vip          : 购买人或者分享人是否是vip
     */
    private void giveProfitUserCommission(Long profitUserId, Boolean vip, ProfitTypeEnum profitType, BigDecimal money, OrderInfo orderInfo) {
        if (money.compareTo(BigDecimal.ZERO) < 1) {
            return;
        }
        //增加记录
        OrderProfit profit = new OrderProfit();
        profit.setUserId(profitUserId);
        profit.setOrderId(orderInfo.getId());
        profit.setGoodsId(orderInfo.getGoodsId());
        profit.setType(profitType.getCode());
        profit.setOrderSn(orderInfo.getOrderSn());
        profit.setOrderOwnerUserId(orderInfo.getOwnerUserId());
        profit.setOrderStatus(OrderStatusEnum.UNSETTLED.getStatus());
        profit.setProfitAmount(money);
        profit.setProfitRate(getRate(vip, profitType));
        Date now = new Date();
        profit.setCreateTime(now);
        profit.setModifyTime(now);
        orderProfitExtendMapper.insertSelective(profit);
        CashFlowTypeEnum cashFlowTypeEnum;
        if (Objects.equals(profitUserId, orderInfo.getOwnerUserId())) {
            cashFlowTypeEnum = CashFlowTypeEnum.REBATE_CASH;
        } else {
            cashFlowTypeEnum = CashFlowTypeEnum.APPLET_BOUNTY;
        }

        //增加金额
        addTakeoutOrderCheckCash(profitUserId, money, orderInfo.getId(), cashFlowTypeEnum);
    }

    /**
     * 增加审核佣金
     *
     * @param userId     用户id
     * @param commission 佣金金额
     * @param orderId    订单id
     */
    private void addTakeoutOrderCheckCash(Long userId, BigDecimal commission, Long orderId, CashFlowTypeEnum cashFlowTypeEnum) {
        // 添加拟结算金额
        CashAccountParam param = new CashAccountParam();
        param.setUserId(userId);
        param.setAccountAction(AccountActionEnum.ADD_REBATE_CASH);
        param.setCashFlowType(cashFlowTypeEnum);
        param.setAmount(commission);
        param.setRelationId(orderId);
        param.setRemark("购买商家商品");
        userAccountIntegrationService.cashAccountOperation(param);
    }

    /**
     * 修改商家订单信息
     *
     * @param userGoodsParam ： 商家订单
     */
    private void updateMerchantOrder(UserGoodsParam userGoodsParam) {
        MerchantOrderInfoDTO merchantOrder = new MerchantOrderInfoDTO();
        merchantOrder.setOrderNo(userGoodsParam.getOrderNo());
        merchantOrder.setPromotionMoney(userGoodsParam.getOrderInfo().getCommission());
        merchantOrder.setPayTime(new Date());
        merchantOrder.setServiceMoney(getServiceMoney(userGoodsParam.getOrderInfo().getPayPrice()));

        BigDecimal receiveMoney = userGoodsParam.getOrderInfo().getPayPrice()
                .subtract(merchantOrder.getPromotionMoney())
                .subtract(merchantOrder.getServiceMoney());

        merchantOrder.setReceiveMoney(receiveMoney);
        // 1-已付款待使用
        merchantOrder.setState(PAYED.getStatus());
        merchantGoodsIntegrationService.updateMerchantOrderByNo(merchantOrder);
    }

    private void openVip(Long userId, Long orderId) {
        ActivationUserVipParam param = new ActivationUserVipParam();
        param.setOrderId(orderId);
        param.setUserId(userId);
        userVipIntegrationService.buyVip(param);
    }
}
