/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.service.order.usergoods.impl;

import com.bxm.component.tbk.order.model.enums.OrderStatusEnum;
import com.bxm.localnews.market.model.constant.CommonConstant;
import com.bxm.localnews.market.model.dto.MerchantOrderInfoDTO;
import com.bxm.localnews.market.model.dto.UserGoodsParam;
import com.bxm.localnews.market.model.entity.OrderInfo;
import com.bxm.localnews.market.model.enums.OrderTypeEnum;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

import static com.alibaba.fastjson.JSON.toJSONString;
import static com.bxm.localnews.market.model.enums.MerchantOrderStatusEnum.PAYED;

/**
 * @author jieliGG
 * @date 2020/8/26 22:10
 * 退单失败-就是待核销，但是和待核销逻辑处理不同
 **/
@Slf4j
@Component
public class RefundFailOrderState extends AbstractOrderState {

    @Override
    public Message notRefund(UserGoodsParam userGoodsParam) {

        log.info("拒绝退款请求, param: {}", toJSONString(userGoodsParam));

        // 只做订单状态修改
        OrderInfo orderInfo = orderInfoMapper.selectByOrderSnAndOrderType(userGoodsParam.getOrderNo(), OrderTypeEnum.WANSHITONG_ONE.getCode());

        if (Objects.isNull(orderInfo)) {
            return Message.build(false, "订单不存在");
        }

        if(!Objects.equals(orderInfo.getOrderStatus(), OrderStatusEnum.REFUNDING.getStatus())){
            log.info("订单: {}, 状态: {} 不是可拒绝退矿状态", userGoodsParam.getOrderNo(), orderInfo.getOrderStatus());
            return Message.build(false, "订单状态不可拒绝退款");
        }

        OrderInfo update = new OrderInfo();
        update.setId(orderInfo.getId());
        update.setOrderStatus(OrderStatusEnum.SUCCESS_PAY.getStatus());
        orderInfoMapper.updateByPrimaryKeySelective(update);
        userGoodsParam.setOrderInfo(orderInfo);


        MerchantOrderInfoDTO merchantOrder = new MerchantOrderInfoDTO();
        merchantOrder.setOrderNo(userGoodsParam.getOrderNo());
        merchantOrder.setState(PAYED.getStatus());
        merchantGoodsIntegrationService.updateMerchantOrderByNo(merchantOrder);

        return Message.build(true).addParam(CommonConstant.CREATE_ORDER_INFO_KEY,userGoodsParam.getOrderInfo());
    }


}
