/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.service.order.usergoods.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.tbk.order.model.enums.OrderStatusEnum;
import com.bxm.localnews.enums.MerchantBossAccountActionEnum;
import com.bxm.localnews.market.domain.OrderProfitMapper;
import com.bxm.localnews.market.dto.PaymentOrderInfoDTO;
import com.bxm.localnews.market.integration.PaymentInfoIntegrationService;
import com.bxm.localnews.market.model.constant.CommonConstant;
import com.bxm.localnews.market.model.dto.MerchantGoodsInfoDTO;
import com.bxm.localnews.market.model.dto.MerchantOrderInfoDTO;
import com.bxm.localnews.market.model.dto.UserGoodsParam;
import com.bxm.localnews.market.model.entity.OrderInfo;
import com.bxm.localnews.market.model.enums.OrderTypeEnum;
import com.bxm.localnews.market.param.OperatorMerchantAccountParam;
import com.bxm.localnews.market.param.RefundParam;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Objects;

import static com.bxm.localnews.market.model.enums.MerchantOrderStatusEnum.REFUNDED;

/**
 * @author jieliGG
 * @date 2020/8/26 22:11
 * 同意退款
 **/
@Slf4j
@Component
public class RefundYesOrderState extends AbstractOrderState {

    @Autowired
    private PaymentInfoIntegrationService paymentInfoIntegrationService;

    @Autowired
    private OrderProfitMapper orderProfitMapper;

    @Override
    public Message yesRefund(UserGoodsParam userGoodsParam) {
        log.info("同意退款，param: {}", JSON.toJSONString(userGoodsParam));

        OrderInfo orderInfo = orderInfoMapper.selectByOrderSnAndOrderType(userGoodsParam.getOrderNo(), OrderTypeEnum.WANSHITONG_ONE.getCode());

        if (Objects.isNull(orderInfo)) {
            return Message.build(false, "订单不存在");
        }

        if (!Objects.equals(orderInfo.getOrderStatus(), OrderStatusEnum.REFUNDING.getStatus())) {
            return Message.build(false, "订单不是退款中状态，无法处理");
        }

        userGoodsParam.setOrderInfo(orderInfo);
        //同意退款
        //归还库存
        merchantGoodsIntegrationService.returnGoodsNum(Long.parseLong(orderInfo.getGoodsId()), orderInfo.getGoodsNum());
        //用户金额退回
        refund(orderInfo);
        //状态修改
        OrderInfo update = new OrderInfo();
        update.setId(orderInfo.getId());
        update.setOrderStatus(OrderStatusEnum.REFUND_SUCCESS.getStatus());
        orderInfoMapper.updateByPrimaryKeySelective(update);


        // 5退单成功
        updateMerchantOrder(userGoodsParam);

        //商家金额变更
        changeMerchantAccount(userGoodsParam);

        // 用户金额为结算失败
        cancelCommission(orderInfo.getOrderSn(), orderInfo.getOrderType());

        return Message.build(true).addParam(CommonConstant.CREATE_ORDER_INFO_KEY, userGoodsParam.getOrderInfo());
    }



    /**
     * 修改商家订单信息
     * @param userGoodsParam ： 商家订单
     */
    private void updateMerchantOrder(UserGoodsParam userGoodsParam){
        MerchantOrderInfoDTO merchantOrder = new MerchantOrderInfoDTO();
        merchantOrder.setOrderNo(userGoodsParam.getOrderNo());
        merchantOrder.setState(REFUNDED.getStatus());
        merchantGoodsIntegrationService.updateMerchantOrderByNo(merchantOrder);
    }

    /**
     * 修改商家账户信息
     *
     * @param userGoodsParam : 入参
     */
    private void changeMerchantAccount(UserGoodsParam userGoodsParam) {

        OrderInfo orderInfo = userGoodsParam.getOrderInfo();
        OperatorMerchantAccountParam accountParam = new OperatorMerchantAccountParam();
        accountParam.setActionEnum(MerchantBossAccountActionEnum.ACCOUNT_ACTION_DRAWBACK);
        accountParam.setPayMoney(orderInfo.getPayPrice());
        accountParam.setServiceMoney(getServiceMoney(orderInfo.getPayPrice()));
        accountParam.setPromotionMoney(orderInfo.getCommission());
        //商家实际到账金额：支付金额 - 服务费 - 佣金
        accountParam.setReceiveMoney(orderInfo.getPayPrice().subtract(accountParam.getServiceMoney()).subtract(accountParam.getPromotionMoney()));
        accountParam.setGoodsName(orderInfo.getGoodsName());
        accountParam.setOrderSn(orderInfo.getOrderSn());
        accountParam.setRelationId(orderInfo.getId());
        //获取商家和商品信息
        MerchantGoodsInfoDTO merchantGoodsInfoDTO = merchantGoodsIntegrationService.getMerchantGoodsById(Long.parseLong(orderInfo.getGoodsId()));
        accountParam.setMerchantId(merchantGoodsInfoDTO.getMerchantId());
        merchantGoodsIntegrationService.operatorMerchantAccount(accountParam);
    }

    /**
     * 退单
     *
     * @param orderInfo : 订单
     */
    private void refund(OrderInfo orderInfo) {
        //订单号查找流水信息
        PaymentOrderInfoDTO orderInfoDTO = paymentInfoIntegrationService.getPaymentNumByOrderSn(orderInfo.getOrderSn());
        if (null == orderInfoDTO) {
            return;
        }
        RefundParam param = new RefundParam();
        if (Objects.equals(orderInfo.getOpenVip().compareTo(BigDecimal.ZERO), 0)) {
            param.setFullAmount(true);
        } else {
            param.setFullAmount(false);
            param.setRefundFee(orderInfo.getPayPrice());
        }
        param.setPaymentNum(orderInfoDTO.getPaymentNum());
        paymentInfoIntegrationService.refund(param);
    }
}
