/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.service.order.usergoods.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.tbk.order.model.enums.OrderStatusEnum;
import com.bxm.localnews.market.model.constant.CommonConstant;
import com.bxm.localnews.market.model.dto.MerchantOrderInfoDTO;
import com.bxm.localnews.market.model.dto.UserGoodsParam;
import com.bxm.localnews.market.model.entity.OrderInfo;
import com.bxm.localnews.market.model.enums.OrderTypeEnum;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Objects;

import static com.bxm.localnews.market.model.enums.MerchantOrderStatusEnum.REFUND_START;

/**
 * @author jieliGG
 * @date 2020/8/26 22:09
 * 退单中订单状态
 **/
@Slf4j
@Component
public class RefundingOrderState extends AbstractOrderState {
    @Autowired
    private RefundYesOrderState refundYesOrderState;

    @Autowired
    private RefundFailOrderState refundFailOrderState;

    @Override
    public Message refund(UserGoodsParam userGoodsParam) {
        log.info("发起退款，param: {}", JSON.toJSONString(userGoodsParam));

        // 更改订单状态就OK
        OrderInfo orderInfo = orderInfoMapper.selectByOrderSnAndOrderType(userGoodsParam.getOrderNo(), OrderTypeEnum.WANSHITONG_ONE.getCode());
        if (Objects.isNull(orderInfo)) {
            return Message.build(false).setMessage("订单不存在");
        }

        if (!Objects.equals(orderInfo.getOrderStatus(), OrderStatusEnum.SUCCESS_PAY.getStatus())) {
            return Message.build(false).setMessage("当前订单不可申请退款");
        }

        OrderInfo update = new OrderInfo();
        update.setOrderStatus(OrderStatusEnum.REFUNDING.getStatus());
        update.setId(orderInfo.getId());
        orderInfoMapper.updateByPrimaryKeySelective(update);


        userGoodsParam.setOrderInfo(orderInfo);
        //更改商家订单为退款中
        updateMerchantOrder(userGoodsParam);

        return Message.build(true).addParam(CommonConstant.CREATE_ORDER_INFO_KEY, userGoodsParam.getOrderInfo());
    }

    /**
     * 修改商家订单信息
     *
     * @param userGoodsParam ： 商家订单
     */
    private void updateMerchantOrder(UserGoodsParam userGoodsParam) {
        MerchantOrderInfoDTO merchantOrder = new MerchantOrderInfoDTO();
        merchantOrder.setOrderNo(userGoodsParam.getOrderNo());
        // 3：退单待确认
        merchantOrder.setState(REFUND_START.getStatus());
        merchantOrder.setRefundTime(new Date());
        merchantGoodsIntegrationService.updateMerchantOrderByNo(merchantOrder);
    }

    @Override
    public Message yesRefund(UserGoodsParam userGoodsParam) {
        return refundYesOrderState.yesRefund(userGoodsParam);
    }

    @Override
    public Message notRefund(UserGoodsParam userGoodsParam) {
        return refundFailOrderState.notRefund(userGoodsParam);
    }
}
