/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.service.order.usergoods.impl;

import com.bxm.component.tbk.order.model.enums.OrderStatusEnum;
import com.bxm.localnews.market.model.constant.CommonConstant;
import com.bxm.localnews.market.model.dto.MerchantOrderInfoDTO;
import com.bxm.localnews.market.model.dto.UserGoodsParam;
import com.bxm.localnews.market.model.entity.OrderInfo;
import com.bxm.localnews.market.model.enums.OrderTypeEnum;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Component;

import java.util.Objects;

import static com.bxm.localnews.market.model.enums.MerchantOrderStatusEnum.EXPIRED;

/**
 * @author jieliGG
 * @date 2020/8/26 17:10
 * 未支付订单，订单过期
 **/
@Component
public class UnpayOrderState extends AbstractOrderState {


    @Override
    public Message unPayOrder(UserGoodsParam userGoodsParam) {
        OrderInfo orderInfo = userGoodsParam.getOrderInfo();
        //更改订单状态
        if(null != orderInfo){
            if(Objects.equals(orderInfo.getOrderStatus(), OrderStatusEnum.UNPAY.getStatus())){
                orderInfo.setOrderStatus(OrderStatusEnum.TIMEOUT_PAY.getStatus());
            }else{
                return Message.build(false);
            }
        }else{
            orderInfo = orderInfoMapper.selectByOrderSnAndOrderType(userGoodsParam.getOrderNo(), OrderTypeEnum.WANSHITONG_ONE.getCode());
            if(null == orderInfo
                    || !Objects.equals(orderInfo.getOrderStatus(), OrderStatusEnum.UNPAY.getStatus())){
                return Message.build(false);
            }
            orderInfo.setOrderStatus(OrderStatusEnum.TIMEOUT_PAY.getStatus());
        }
        orderInfoMapper.updateOrderStatusByOrderSnOrderType(orderInfo);
        userGoodsParam.setOrderInfo(orderInfo);
        //退还商品库存
        merchantGoodsIntegrationService.returnGoodsNum(Long.parseLong(orderInfo.getGoodsId()),orderInfo.getGoodsNum());

        MerchantOrderInfoDTO merchantOrder = new MerchantOrderInfoDTO();
        merchantOrder.setOrderNo(userGoodsParam.getOrderNo());
        // 6：订单未支付过期
        merchantOrder.setState(EXPIRED.getStatus());
        merchantGoodsIntegrationService.updateMerchantOrderByNo(merchantOrder);

        return Message.build(true).addParam(CommonConstant.CREATE_ORDER_INFO_KEY,userGoodsParam.getOrderInfo());
    }


}
