package com.bxm.localnews.market.service.order.usergoods.impl;

import com.bxm.component.tbk.order.model.enums.OrderStatusEnum;
import com.bxm.localnews.constants.RedisConfig;
import com.bxm.localnews.enums.MerchantBossAccountActionEnum;
import com.bxm.localnews.market.domain.OrderProfitMapper;
import com.bxm.localnews.market.integration.UserAccountIntegrationService;
import com.bxm.localnews.market.model.constant.CommonConstant;
import com.bxm.localnews.market.model.dto.MerchantOrderInfoDTO;
import com.bxm.localnews.market.model.dto.MerchantGoodsInfoDTO;
import com.bxm.localnews.market.model.dto.UserGoodsParam;
import com.bxm.localnews.market.model.entity.OrderInfo;
import com.bxm.localnews.market.model.entity.OrderProfit;
import com.bxm.localnews.market.param.CashAccountParam;
import com.bxm.localnews.market.param.OperatorMerchantAccountParam;
import com.bxm.localnews.user.enums.AccountActionEnum;
import com.bxm.localnews.user.enums.AppConst;
import com.bxm.localnews.user.enums.CashFlowTypeEnum;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Objects;

import static com.bxm.localnews.market.model.enums.MerchantOrderStatusEnum.USED;

/**
 * @author jieliGG
 * @date 2020/8/26 22:13
 * 核销成功
 **/
@Component
public class VerificationOrderState extends AbstractOrderState {

    private final UserAccountIntegrationService userAccountIntegrationService;

    private final OrderProfitMapper orderProfitMapper;

    private final RedisStringAdapter redisStringAdapter;
    @Autowired
    public VerificationOrderState(UserAccountIntegrationService userAccountIntegrationService,
                                  OrderProfitMapper orderProfitMapper, RedisStringAdapter redisStringAdapter) {
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.orderProfitMapper = orderProfitMapper;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public Message verification(UserGoodsParam userGoodsParam) {
        OrderInfo orderInfo = userGoodsParam.getOrderInfo();

        //调用账户模块更改账户
        userGoodsParam.setOrderInfo(orderInfo);
        updateMerchantAccount(userGoodsParam);

        //购物佣金结算
        this.addTakeoutOrderCheckCash(orderInfo);

        //更新订单
        orderInfo.setOrderStatus(OrderStatusEnum.VERIFICATION_PAY.getStatus());
        orderInfoMapper.updateOrderStatusByOrderSnOrderType(orderInfo);

        MerchantOrderInfoDTO merchantOrder = new MerchantOrderInfoDTO();
        merchantOrder.setOrderNo(userGoodsParam.getOrderNo());
        // 6：订单已核销
        merchantOrder.setState(USED.getStatus());
        merchantGoodsIntegrationService.updateMerchantOrderByNo(merchantOrder);
        return Message.build(true).addParam(CommonConstant.CREATE_ORDER_INFO_KEY,userGoodsParam.getOrderInfo())
                .addParam(CommonConstant.VERIFICATION_ORDER_STATE,CommonConstant.SUCCESS);
    }

    private void updateMerchantAccount(UserGoodsParam userGoodsParam){
        OrderInfo orderInfo = userGoodsParam.getOrderInfo();
        OperatorMerchantAccountParam accountParam = new OperatorMerchantAccountParam();
        accountParam.setActionEnum(MerchantBossAccountActionEnum.ACCOUNT_ACTION_VERIFY_CANCEL);
        accountParam.setPayMoney(orderInfo.getPayPrice());
        accountParam.setServiceMoney(getServiceMoney(orderInfo.getPayPrice()));
        accountParam.setPromotionMoney(orderInfo.getCommission());
        //商家实际到账金额：支付金额 - 服务费 - 佣金
        accountParam.setReceiveMoney(orderInfo.getPayPrice().subtract(accountParam.getServiceMoney()).subtract(accountParam.getPromotionMoney()));
        accountParam.setGoodsName(orderInfo.getGoodsName());
        accountParam.setOrderSn(orderInfo.getOrderSn());
        accountParam.setRelationId(orderInfo.getId());
        MerchantGoodsInfoDTO merchantGoodsInfoDTO = merchantGoodsIntegrationService.getMerchantGoodsById(Long.parseLong(orderInfo.getGoodsId()));
        accountParam.setMerchantId(merchantGoodsInfoDTO.getMerchantId());
        merchantGoodsIntegrationService.operatorMerchantAccount(accountParam);
    }
    /**
     * 增加结算完成
     *
     * @param orderInfo    订单号

     */
    private void addTakeoutOrderCheckCash(OrderInfo orderInfo) {
        //带来收益的订单id
        Long settleOrderId = orderInfo.getId();
        Long benefitUser = redisStringAdapter.get(RedisConfig.MARKET_RECORD_GOODS_SHARE_USER.copy().appendKey(orderInfo.getOrderSn()), Long.class);
        List<OrderProfit> profitList = orderProfitMapper.getAllProfitListByOrderId(orderInfo.getId());
        for(OrderProfit orderProfit : profitList){
            if(Objects.equals(orderProfit.getOrderStatus(),OrderStatusEnum.UNSETTLED.getStatus())){
                // 添加拟结算金额
                CashAccountParam param = new CashAccountParam();
                param.setUserId(orderProfit.getUserId());
                param.setAccountAction(AccountActionEnum.REBATE_SETTLE);
                param.setCashFlowType(CashFlowTypeEnum.REBATE_CASH);
                param.setAmount(orderProfit.getProfitAmount());
                param.setRelationId(orderInfo.getId());
                if(Objects.equals(orderProfit.getUserId(),orderInfo.getOwnerUserId())){
                    param.setRemark("自购佣金结算");
                }else if(Objects.equals(orderProfit.getUserId(),benefitUser)){
                    param.setRemark("邀请好友购买"+ org.apache.commons.lang3.StringUtils.substring(orderInfo.getGoodsName(),0,5));
                }else{
                    param.setRemark("好友购买"+ org.apache.commons.lang3.StringUtils.substring(orderInfo.getGoodsName(),0,5));
                }

                userAccountIntegrationService.cashAccountOperation(param);
                //赋值orderId
                settleOrderId = orderProfit.getOrderId();
            }
        }
        //更新分佣订单的状态t_order_info的状态为已结算
        orderProfitMapper.settleOrderByOrderParentSn(orderInfo.getOrderSn(),OrderStatusEnum.HAVE_SETTLED.getStatus());

       if(!CollectionUtils.isEmpty(profitList)){
           //更新结算状态
           orderProfitMapper.settleProfitByOid(settleOrderId, AppConst.ENABLE);
       }
    }

}
