package com.bxm.localnews.market.timer;

import com.bxm.localnews.market.model.dto.KfcOrderDTO;
import com.bxm.localnews.market.service.KfcOrderAcquireService;
import com.bxm.localnews.market.service.KfcOrderAcquireService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

/**
 * KFC在线点餐订单获取定时任务
 *
 * @author wzy
 * @date 2020/8/4 18:57
 **/
@Component
@Slf4j
public class KfcOrderAcquireTask extends AbstractCronTask<String> {

    private final KfcOrderAcquireService kfcOrderAcquireService;

    @Autowired
    public KfcOrderAcquireTask(KfcOrderAcquireService kfcOrderAcquireService) {
        this.kfcOrderAcquireService = kfcOrderAcquireService;
    }

    @Override
    protected ReturnT<String> service(String s) {
        try {
            LocalDateTime currentTime = LocalDateTime.now();
            LocalDateTime startTime = currentTime.minusMinutes(10);
            List<KfcOrderDTO.Order> orderList = kfcOrderAcquireService.getThirdPartyOrder(startTime, currentTime);
            for (KfcOrderDTO.Order thirdPartyOrder : orderList) {
                kfcOrderAcquireService.handleThirdPartyOrder(thirdPartyOrder, true, true);
            }
        } catch (Exception e) {
            log.error("获取千猪KFC订单查询失败", e);
        }

        return ReturnT.SUCCESS;
    }


    @Override
    public String taskName() {
        return "MARKET_KFC_ORDER_ACQUIRE_TASK";
    }

    @Override
    public String cron() {
        return "0 */1 * * * ?";
    }

    @Override
    public String description() {
        return "每分钟获取一次千猪肯德基在线点餐订单_LOCAL_NEWS_MARKET";
    }
}
