package com.bxm.localnews.market.timer;

import com.bxm.localnews.market.model.dto.OilGroupOrderDTO;
import com.bxm.localnews.market.service.OilGroupOrderAcquireService;
import com.bxm.localnews.market.service.OilGroupOrderAcquireService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 团油订单获取定时任务
 *
 * @author wzy
 * @date 2020/8/4 19:00
 **/
@Component
@Slf4j
public class OilGroupOrderAcquireTask extends AbstractCronTask<String> {

    private final OilGroupOrderAcquireService oilGroupOrderAcquireService;

    public OilGroupOrderAcquireTask(OilGroupOrderAcquireService oilGroupOrderAcquireService) {
        this.oilGroupOrderAcquireService = oilGroupOrderAcquireService;
    }


    @Override
    protected ReturnT<String> service(String s) {
        LocalDateTime currentTime = LocalDateTime.now();
        LocalDateTime startTime = currentTime.minusMinutes(10);
        //获取第三方订单数据，手机号码这里传递null
        List<OilGroupOrderDTO.Order> orderList = oilGroupOrderAcquireService.getThirdPartyOrder(startTime, currentTime, null);
        for (OilGroupOrderDTO.Order thirdPartyOrder : orderList) {
            oilGroupOrderAcquireService.handleThirdPartyOrder(thirdPartyOrder, startTime,
                    currentTime, true, true, true);
        }
        return ReturnT.SUCCESS;
    }


    @Override
    public String taskName() {

        return "MARKET_OIL_ORDER_ACQUIRE_TASK";
    }

    @Override
    public String cron() {
        return "0 */1 * * * ?";
    }

    @Override
    public String description() {
        return "每分钟获取一次团油订单_LOCAL_NEWS_MARKET";
    }
}
