package com.bxm.localnews.market.timer;

import com.bxm.localnews.market.model.dto.GoodsOrderEventDTO;
import com.bxm.localnews.market.model.enums.GoodsOrderEventEnum;
import com.bxm.localnews.market.model.param.OrderCancelTaskParam;
import com.bxm.localnews.market.service.order.usergoods.event.GoodsOrderManage;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static com.alibaba.fastjson.JSON.toJSONString;
import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * @author gonzo
 * @date 2020-09-06 12:44
 **/
@Slf4j
@Component
public class OrderCancelTask extends AbstractTaskCallback<OrderCancelTaskParam> {

    @Autowired
    private GoodsOrderManage goodsOrderManage;

    @Override
    protected ReturnT<String> service(OrderCancelTaskParam param) {
        try {
            log.info("处理订单超时未支付 param: {}", toJSONString(param));

            if (isBlank(param.getOrderSn())) {
                log.warn("处理订单超时未支付，订单号不存在");
                return ReturnT.FAIL;
            }

            // 订单超时未支付
            GoodsOrderEventDTO orderEventDTO = new GoodsOrderEventDTO();
            orderEventDTO.setOrderNo(param.getOrderSn());
            orderEventDTO.setGoodsOrderEventEnum(GoodsOrderEventEnum.UNPAY);
            goodsOrderManage.orderProcess(orderEventDTO);
            return ReturnT.SUCCESS;
        } catch(Exception e) {
            log.error("处理超时未支付订单失败，param: {}", toJSONString(param), e);
        }
        return ReturnT.FAIL;
    }

}
