package com.bxm.localnews.market.timer;

import com.bxm.component.tbk.order.model.enums.OrderStatusEnum;
import com.bxm.component.tbk.order.model.enums.OrderTypeEnum;
import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.constants.RedisConfig;
import com.bxm.localnews.market.domain.OrderInfoMapper;
import com.bxm.localnews.market.model.dto.CardCouponOrderDTO;
import com.bxm.localnews.market.model.dto.GoodsOrderEventDTO;
import com.bxm.localnews.market.model.entity.OrderInfo;
import com.bxm.localnews.market.model.enums.GoodsOrderEventEnum;
import com.bxm.localnews.market.service.TaoQuanOrderAcquireService;
import com.bxm.localnews.market.service.order.usergoods.event.GoodsOrderManage;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.StringUtils;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;

import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

/**
 * 查找退单待审核的订单
 *
 * @author xujieli
 * @date 2020年9月4日 11:47:35
 **/
@Component
@Slf4j
public class RefundWaitAuditTask extends AbstractCronTask<String> {

    @Autowired
    private OrderInfoMapper orderInfoMapper;
    @Autowired
    private GoodsOrderManage goodsOrderManage;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private MessageSender messageSender;

    @Override
    protected ReturnT<String> service(String s) {
        try {
            //待审核订单查询
            List<OrderInfo> listOrderRefunding =  orderInfoMapper.getByOrderStatusRefunding(OrderStatusEnum.REFUNDING.getStatus(), com.bxm.localnews.market.model.enums.OrderTypeEnum.WANSHITONG_ONE.name());
            for(OrderInfo entity : listOrderRefunding){
                GoodsOrderEventDTO orderEventDTO = new GoodsOrderEventDTO();
                orderEventDTO.setOrderNo(entity.getOrderSn());
                orderEventDTO.setGoodsOrderEventEnum(GoodsOrderEventEnum.REFUND_YES);
                goodsOrderManage.orderProcess(orderEventDTO);
            }
            //订单支付超过5天未使用-发推送
            List<OrderInfo> listOrderUnuse =  orderInfoMapper.getByOrderStatusUnuse(OrderStatusEnum.REFUNDING.getStatus(), com.bxm.localnews.market.model.enums.OrderTypeEnum.WANSHITONG_ONE.name());
            for(OrderInfo entity : listOrderUnuse){
                pushMessage(entity.getOwnerUserId(),entity.getOrderSn());
            }
        } catch (Exception e) {
            log.error("", e);
        }

        return ReturnT.SUCCESS;
    }

    /**
     * 给用户发推送
     * @param userId
     */
    private void pushMessage(Long userId,String orderSn){
        if(Objects.equals(redisHashMapAdapter.exists(RedisConfig.MARKET_ORDER_UNUSE_TIMEOUT_FIVE,orderSn),Boolean.FALSE)){
            //构建推送消息体
            PushPayloadInfo pushPayloadInfo = PushPayloadInfo.build(PushMessageEnum.JUMP_TYPE);
            pushPayloadInfo.setProtocol(buildProtocol(userId));

            PushMessage message = PushMessage.build();
            message.setTitle("消费提醒");
            message.setContent("您有一笔订单待消费，赶快去查看哦~");
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPayloadInfo(pushPayloadInfo);
            message.assign(userId);

            //推送
            messageSender.sendPushMessage(message);
        }
    }
    /**
     * 构建商户通知消息的跳转协议地址
     *
     * @return 组装的客户端协议，我的订单-待使用页
     */
    private String buildProtocol(Long userId) {
        return "wst://mine/billingDetail?userId=" + userId;
    }
    @Override
    public String taskName() {
        return "MARKET_REFUND_WAIT_AUDIT";
    }

    @Override
    public String cron() {
        return "0 */1 * * * ?";
    }

    @Override
    public String description() {
        return "每分钟去查找并处理[退单申请审核超时]的订单";
    }
}
