package com.bxm.localnews.market.timer;

import com.bxm.localnews.market.model.dto.CardCouponOrderDTO;
import com.bxm.localnews.market.service.TaoQuanOrderAcquireService;
import com.bxm.localnews.market.service.TaoQuanOrderAcquireService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 365卡券订单获取定时任务
 *
 * @author wzy
 * @date 2020/8/4 18:55
 **/
@Component
@Slf4j
public class Taoquan365OrderAcquireTask extends AbstractCronTask<String> {

    private final TaoQuanOrderAcquireService taoQuanOrderAcquireService;

    public Taoquan365OrderAcquireTask(TaoQuanOrderAcquireService taoQuanOrderAcquireService) {
        this.taoQuanOrderAcquireService = taoQuanOrderAcquireService;
    }

    @Override
    protected ReturnT<String> service(String s) {
        try {
            LocalDateTime currentTime = LocalDateTime.now();
            LocalDateTime startTime = currentTime.minusMinutes(10);
            //获取第三方订单数据
            List<CardCouponOrderDTO.Order> orderList = taoQuanOrderAcquireService.getThirdPartyOrder(startTime, currentTime);
            for (CardCouponOrderDTO.Order order : orderList) {
                taoQuanOrderAcquireService.handleThirdPartyOrder(order, true, true);
            }
        } catch (Exception e) {
            log.error("365卡券H5链接订单查询失败", e);
        }

        return ReturnT.SUCCESS;
    }


    @Override
    public String taskName() {
        return "MARKET_CARD_ORDER_ACQUIRE_TASK";
    }

    @Override
    public String cron() {
        return "0 */1 * * * ?";
    }

    @Override
    public String description() {
        return "每分钟获取一次365淘券订单_LOCAL_NEWS_MARKET";
    }
}
