/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.timer;
import com.bxm.component.tbk.order.model.enums.OrderStatusEnum;
import com.bxm.localnews.market.domain.OrderInfoMapper;
import com.bxm.localnews.market.model.dto.GoodsOrderEventDTO;
import com.bxm.localnews.market.model.entity.OrderInfo;
import com.bxm.localnews.market.model.enums.GoodsOrderEventEnum;
import com.bxm.localnews.market.model.enums.OrderTypeEnum;
import com.bxm.localnews.market.service.OrderInfoService;
import com.bxm.localnews.market.service.order.usergoods.event.GoodsOrderManage;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author jieliGG
 * @date 2020/9/4 19:26
 * 超时支付的订单退还
 **/
@Component
@Slf4j
public class TimeoutOrderTask  extends AbstractCronTask<String> {

    @Autowired
    private OrderInfoMapper orderInfoMapper;
    @Autowired
    private GoodsOrderManage goodsOrderManage;

    @Override
    protected ReturnT<String> service(String s) {
        List<OrderInfo> listOrder = orderInfoMapper.getByOrderStatusUnpay(OrderStatusEnum.UNPAY.getStatus(), OrderTypeEnum.WANSHITONG_ONE.name());
        for(OrderInfo orderInfo : listOrder){
            returnGood(orderInfo.getOrderSn());
        }
        return ReturnT.SUCCESS;
    }

    /**
     * 退还商品信息
     * @param orderSn
     */
    private void returnGood(String orderSn){
        GoodsOrderEventDTO orderEventDTO = new GoodsOrderEventDTO();
        orderEventDTO.setOrderNo(orderSn);
        orderEventDTO.setGoodsOrderEventEnum(GoodsOrderEventEnum.UNPAY);
        goodsOrderManage.orderProcess(orderEventDTO);
    }

    @Override
    public String taskName() {
        return "MARKET_TIMEOUT_MERCHANT_ORDER";
    }

    @Override
    public String cron() {
        return "0 */1 * * * ?";
    }

    @Override
    public String description() {
        return "每分钟去查找并处理[超时订单]的订单";
    }
}
