package com.bxm.localnews.market.util;

import lombok.SneakyThrows;
import lombok.experimental.UtilityClass;

import java.util.Map;
import java.util.TreeMap;

/**
 * 签名工具类
 *
 * @author wzy
 * @date 2020/4/10
 */
@UtilityClass
public class SignUtils {


    /**
     * 生成签名,通过url拼接的方式
     *
     * @param map    要验签的对象map
     * @param secret 密钥
     * @return 签名
     */
    @SneakyThrows
    public static String generateSign(Map<String, Object> map, String secret) {
        Map<String, Object> reqMap = new TreeMap<>(map);

        StringBuilder paramBuilder = new StringBuilder();
        reqMap.forEach((k, v) ->
                paramBuilder.append(String.format("%s=%s&", k, v == null ? "" : v))
        );
        String paramStr = paramBuilder.substring(0, paramBuilder.length() - 1);
        paramStr = paramStr + secret;

        return Md5Utils.md5(paramStr);
    }

    /**
     * 生成签名，通过连接参数名和参数值的方式
     *
     * @param map    参数列表
     * @param secret 密钥
     * @return 签名
     */
    public static String generateConnectSign(Map<String, Object> map, String secret) {
        Map<String, Object> reqMap = new TreeMap<>(map);

        StringBuilder paramBuilder = new StringBuilder();
        reqMap.forEach((k, v) ->
                paramBuilder.append(String.format("%s%s", k, v == null ? "" : String.valueOf(v)))
        );
        String paramStr = paramBuilder.substring(0, paramBuilder.length());
        // 首尾都连接密钥
        paramStr = secret + paramStr + secret;

        return Md5Utils.md5(paramStr);
    }
}
