package com.bxm.localnews.merchant.action.stream;

import org.springframework.cloud.stream.annotation.Input;
import org.springframework.messaging.SubscribableChannel;

/**
 * spring cloud steam的消息队列
 * 配置
 *
 * @author jieli.xu
 * @date 2020年8月4日 11:39:35
 **/
public interface MessageProcessor {

    /**
     * 用户分享新闻内容
     */
    String SHARE_INPUT = "shareInput";

    /**
     * 用户分享帖子新闻内容
     */
    String SHARE_FORUM_INPUT = "shareForumInput";
    /**
     * 管理后台删除新闻，帖子
     */
    String DELETE_FORUM_INPUT = "deleteForumInput";

    /**
     * 用户冗余信息更新消息 主要是头像和昵称
     */
    String REDUNDANCY_ACTION = "redundanyInput";

    @Input(REDUNDANCY_ACTION)
    SubscribableChannel redundanyInput();

    @Input(SHARE_INPUT)
    SubscribableChannel shareInput();

    @Input(SHARE_FORUM_INPUT)
    SubscribableChannel shareForumInput();

    @Input(DELETE_FORUM_INPUT)
    SubscribableChannel deleteForumInput();
}
