package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchant.coupon.service.CouponInfoService;
import com.bxm.localnews.merchant.coupon.service.CouponStatisticsService;
import com.bxm.localnews.merchant.coupon.service.MerchantCouponService;
import com.bxm.localnews.merchant.dto.coupon.MerchantCouponCheckInfoDTO;
import com.bxm.localnews.merchant.dto.coupon.MerchantCouponOverviewDTO;
import com.bxm.localnews.merchant.dto.coupon.MerchantCouponReportDTO;
import com.bxm.localnews.merchant.param.coupon.*;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author liujia
 * @date 2020-09-18 16:25
 **/
@Api(tags = "11-13 商家优惠券相关接口", description = "包括商家管理优惠券、获取优惠券统计信息等")
@RestController
@RequestMapping("{version}/merchant/coupon/security")
public class MerchantCouponController {

    private final CouponInfoService couponInfoService;

    private final CouponStatisticsService couponStatisticsService;

    private final MerchantCouponService merchantCouponService;

    @Autowired
    public MerchantCouponController(CouponInfoService couponInfoService,
                                    CouponStatisticsService couponStatisticsService,
                                    MerchantCouponService merchantCouponService) {
        this.couponInfoService = couponInfoService;
        this.couponStatisticsService = couponStatisticsService;
        this.merchantCouponService = merchantCouponService;
    }

    @ApiOperation(value = "11-13-01 [v1]根据状态分页获取商家优惠券信息", notes = "状态必须传递，否则返回空数组")
    @GetMapping("list")
    @ApiVersion(1)
    public ResponseJson<PageWarper<MerchantCouponOverviewDTO>> queryByStatus(MerchantCouponStatusPageParam param) {
        return ResponseJson.ok(couponInfoService.query(param));
    }

    @ApiOperation(value = "11-13-02 [v1]停用优惠券",
            notes = "停用指定的优惠券，优惠券必须处于可以停用的状态，并且所属商户必须正确")
    @PostMapping("disable")
    @ApiVersion(1)
    public ResponseJson disable(@RequestBody MerchantCouponParam param) {
        return ResponseJson.build(couponInfoService.disable(param));
    }

    @ApiOperation(value = "11-13-03 [v1]商家创建优惠券", notes = "如果返回状态码不为200，则显示对于的错误信息")
    @PostMapping("create")
    @ApiVersion(1)
    public ResponseJson create(@RequestBody MerchantCouponCreateParam param) {
        return ResponseJson.build(couponInfoService.createCoupon(param));
    }

    @ApiOperation(value = "11-13-04 [v1]查询单个优惠券的报表信息", notes = "包含汇总信息与每日统计")
    @GetMapping("report")
    @ApiVersion(1)
    public ResponseJson<MerchantCouponReportDTO> report(MerchantCouponReportParam param) {
        return ResponseJson.ok(couponStatisticsService.getReport(param));
    }

    @ApiOperation(value = "11-13-05 [v1]根据核销码获取优惠券的核销信息", notes = "如果返回状态码不正确，说明无核销信息，提示对应的错误消息")
    @GetMapping("check/code")
    @ApiVersion(1)
    public ResponseJson<MerchantCouponCheckInfoDTO> getCheckInfoByCode(MerchantCouponCheckCodeParam param) {
        MerchantCouponCheckInfoDTO result = merchantCouponService.getCheckInfoByCode(param);

        if (result == null) {
            return ResponseJson.badReqeuset("核销码不存在或状态错误").build();
        }
        return ResponseJson.ok(result);
    }

    @ApiOperation(value = "11-13-06 [v1]执行优惠券核销", notes = "如果返回状态码不正确，说明核销错误，提示对应的错误消息")
    @PostMapping("check")
    @ApiVersion(1)
    public ResponseJson check(@RequestBody MerchantCouponCheckParam param) {
        return ResponseJson.build(merchantCouponService.check(param));
    }
}
