/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchant.param.MerchantReportParam;
import com.bxm.localnews.merchant.service.count.MerchantPageCollectService;
import com.bxm.newidea.component.annotations.ApiVersion;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author jieliGG
 * @date 2020/7/30 19:03
 **/
@Api(tags = " 11-06 前端商户相关埋点API")
@RestController
@RequestMapping("{version}/merchant/pageCollect")
public class MerchantPageCollectController {

    @Autowired
    private MerchantPageCollectService merchantPageCollectService;

    @ApiOperation(value = "11-06-01 [v1]存储埋点数据", notes = "记录点击行为")
    @ApiVersion(1)
    @PostMapping("toReport")
    public void toReport(@RequestBody MerchantReportParam merchantReportParam) {
        merchantPageCollectService.toReport(merchantReportParam);
    }
}
