package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchant.dto.CreateStatusDto;
import com.bxm.localnews.merchant.dto.MerchantUserInfoDto;
import com.bxm.localnews.merchant.param.CreateParam;
import com.bxm.localnews.merchant.param.EmployeeRemoveParam;
import com.bxm.localnews.merchant.param.MerchantMemberPageParam;
import com.bxm.localnews.merchant.param.RemoveRecordParam;
import com.bxm.localnews.merchant.service.members.MerchantUserService;
import com.bxm.localnews.merchant.vo.MerchantMemberVo;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author: zhoujincheng
 * @create: 2020-07-30 17:04
 */
@Api(tags = " 11-05 商户模块团队绑定关系相关API")
@RestController
@RequestMapping("{version}/merchant/user")
public class MerchantUserController {

    @Autowired
    private MerchantUserService merchantUserService;

    @ApiOperation(value = "11-05-1 【v1】创建绑定关系", notes = "说明：新增一种收徒方式：绑定员工收徒收徒逻辑：绑定的员工为新用户，绑定成功后，徒弟下载登录后建立师徒关系；" +
                  "非新用户，无师徒关系，绑定员工关系不建立师徒关系" ,httpMethod = "POST")
    @PostMapping("/create")
    @ApiVersion(1)
    public ResponseJson<CreateStatusDto> create(@RequestBody @Validated CreateParam createParam) {
        Message message = merchantUserService.create(createParam);
        if (message.isSuccess()) {
            return ResponseJson.ok(message.getParam("createStatusDto"));
        }
        return ResponseJson.build(message);
    }

    @ApiOperation(value = "11-05-2 【v1】解除员工绑定关系", notes = "解除员工绑定关系", httpMethod = "POST")
    @PostMapping("/employeeRemove")
    @ApiVersion(1)
    public ResponseJson<Boolean> remove(@RequestBody @Validated EmployeeRemoveParam employeeRemoveParam) {
        return ResponseJson.build(merchantUserService.remove(employeeRemoveParam));
    }


    @ApiOperation(value = "11-05-3 【v1】删除绑定记录", notes = "删除绑定记录", httpMethod = "POST")
    @PostMapping("/removeRecord")
    @ApiVersion(1)
    public ResponseJson<Boolean> removeRecord(@RequestBody @Validated RemoveRecordParam removeEmployeeParam) {
        return ResponseJson.build(merchantUserService.removeRecord(removeEmployeeParam));
    }

    @GetMapping("/getEmployeeList")
    @ApiOperation(value = "11-05-5  【v1】员工列表", notes = "员工列表", httpMethod = "GET")
    @ApiVersion(1)
    public ResponseJson<PageWarper<MerchantMemberVo>> getEmployeeList(MerchantMemberPageParam merchantMemberPageParam) {
        return ResponseJson.ok(merchantUserService.getEmployeeList(merchantMemberPageParam));
    }

    @ApiOperation(value = "11-05-6 【v1】获取用户头像和昵称和店铺简称相关信息", notes = "获取用户头像和昵称和店铺简称相关信息", httpMethod = "GET")
    @GetMapping("/getUserInfo")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    public ResponseJson<MerchantUserInfoDto> getMerchantUserInfo(@RequestParam("userId") Long userId) {
        Message message = merchantUserService.getMerchantUserInfo(userId);
        if (message.isSuccess()) {
            return ResponseJson.ok(message.getParam("merchantUserInfoDto"));
        }
        return ResponseJson.build(message);
    }

/*    @ApiOperation(value = "11-05-9 【v1】 测试绑定关联关系", notes = "测试绑定关联关系", httpMethod = "GET")
    @GetMapping("/getTest")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    public ResponseJson<RelationshipDto> getTest(@RequestParam("userId") Long userId) {
        return ResponseJson.ok(merchantUserService.getRelationship(userId));
    }*/

}
