/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchant.dto.H5WithdrawDetail;
import com.bxm.localnews.merchant.dto.MerchantH5WithdrawItemDTO;
import com.bxm.localnews.merchant.dto.MerchantToWithdrawDTO;
import com.bxm.localnews.merchant.param.H5MerchantWithdrawListParam;
import com.bxm.localnews.merchant.param.MerchantWithdrawParam;
import com.bxm.localnews.merchant.service.withdraw.MerchantWithdrawService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author jieliGG
 * @date 2020/8/20 22:56
 * 商家提现
 **/
@Api(tags = "11-12 商家提现信息")
@RestController
@AllArgsConstructor
@RequestMapping("{version}/merchant/withdraw")
public class MerchantWithdrawController {

    private final MerchantWithdrawService merchantWithdrawService;

    @ApiOperation(value = "11-12-01 [v1]去提现")
    @ApiVersion(1)
    @PostMapping("/toWithdraw")
    public ResponseJson<MerchantToWithdrawDTO> withdraw(@RequestBody @Validated MerchantWithdrawParam param, HttpServletRequest request) {
        param.setClientIp(WebUtils.getIpAddr(request));
        return ResponseJson.ok(merchantWithdrawService.withdraw(param));
    }

    @GetMapping("/getH5WithdrawList")
    @ApiOperation(value = "11-12-04 [v1]h5获取商家的 提现列表")
    @ApiVersion(1)
    public ResponseJson<PageWarper<MerchantH5WithdrawItemDTO>> getH5WithdrawList(H5MerchantWithdrawListParam param) {
        return ResponseJson.ok(merchantWithdrawService.getH5WithdrawList(param));
    }

    @GetMapping("/getH5WithdrawDetail")
    @ApiOperation(value = "11-12-05 [v1]h5获取商家的 提现详情")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "withdrawId", value = "提现id", required = true)
    })
    public ResponseJson<H5WithdrawDetail> getH5WithdrawDetail(@RequestParam("withdrawId") Long withdrawId) {
        return ResponseJson.ok(merchantWithdrawService.getH5WithdrawDetail(withdrawId));
    }
}
