/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchant.dto.*;
import com.bxm.localnews.merchant.param.IndustryInfoParam;
import com.bxm.localnews.merchant.param.MerchantOpenPromoteParam;
import com.bxm.localnews.merchant.param.PromoteParam;
import com.bxm.localnews.merchant.service.IndustryService;
import com.bxm.localnews.merchant.service.UserInviteService;
import com.bxm.localnews.merchant.service.promote.PromoteService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author : jieli.xu
 * @date 2020/7/9 16:55
 */
@Api(tags = "11-02 推广模块", value = "推广模块信息")
@RestController
@RequestMapping("{version}/merchant/public/promote")
public class PromoteController {

    @Autowired
    private IndustryService industryService;

    @Autowired
    private PromoteService promoteService;

    @Autowired
    private UserInviteService userInviteService;

    @ApiOperation(value = "11-02-1 [v1]获取推广所需要的推广金")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "promoteType", value = "推广类型", required = true, paramType = "Long")
    })
    @GetMapping("getPromoteMoney")
    public ResponseJson<PromoteMoneyDTO> getPromoteMoney(Long userId, Long promoteType) {
        return ResponseJson.ok(promoteService.getPromoteMoney(userId, promoteType));
    }

    @ApiOperation(value = "11-02-2 [v1]推广金明细列表")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
    })
    @GetMapping("getPromoteDetail")
    public ResponseJson<PageWarper<PromoteDetailDTO>> getPromoteDetail(PromoteParam promoteParam) {
        return ResponseJson.ok(promoteService.getPromoteDetail(promoteParam));
    }

    @ApiOperation(value = "11-02-3 [v1]我的推广金信息")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    @GetMapping("getUserPromoteMoney")
    public ResponseJson<UserPromoteMoneyDTO> getUserPromoteMoney(Long userId) {
        return ResponseJson.ok(promoteService.getUserPromoteMoney(userId));
    }

    @ApiOperation(value = "11-02-4 [v1]我的徒弟贡献列表")
    @ApiVersion(1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
    })
    @GetMapping("getDisciplePromote")
    public ResponseJson<PageWarper<UserInviteDTO>> getDisciplePromote(PromoteParam promoteParam) {
        return ResponseJson.ok(userInviteService.getInviteByPage(promoteParam));
    }

    @ApiOperation(value = "11-02-5 [v1]商家跑马灯")
    @ApiVersion(1)
    @GetMapping("getMerchantMarquee")
    public ResponseJson<List<MerchantMarqueeDTO>> getMerchantMarquee() {

        return ResponseJson.ok(promoteService.getMerchantMarquee());
    }

    @ApiOperation(value = "11-02-6 [v1]获取行业列表")
    @ApiVersion(1)
    @GetMapping("getIndustryList")
    public ResponseJson<List<IndustryDTO>> getIndustryList() {
        return ResponseJson.ok(industryService.getListAll(new IndustryInfoParam()));
    }

    @ApiOperation(value = "11-02-7 [v1]点击去开通权益接口")
    @ApiVersion(1)
    @PostMapping("security/toOpenPromote")
    public ResponseJson<PromoteMoneyDTO> toOpenPromote(@RequestBody MerchantOpenPromoteParam promoteParam) {
        return ResponseJson.ok(promoteService.getPromoteMoney(promoteParam.getUserId(), null));
    }


}
