package com.bxm.localnews.merchant.controller.backdoor;

import com.bxm.localnews.merchant.coupon.config.CouponProperties;
import com.bxm.localnews.merchant.coupon.service.CashCouponService;
import com.bxm.localnews.merchant.param.coupon.CashCouponGrantParam;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.ResponseJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Calendar;
import java.util.Date;

/**
 * 优惠券的测试接口
 * 模拟联通的发券流程，方便测试进行处理
 *
 * @author liujia
 * @date 2020-09-24 23:14
 **/
@RestController
@RequestMapping("{version}/merchant/public/backdoor/coupon")
public class CouponTestController {
    private final CashCouponService cashCouponService;

    private final CouponProperties couponProperties;

    @Autowired
    public CouponTestController(CashCouponService cashCouponService,
                                CouponProperties couponProperties) {
        this.cashCouponService = cashCouponService;
        this.couponProperties = couponProperties;
    }

    /**
     * 授予用户一张现金优惠券
     *
     * @param param 发放参数
     * @return 发放结果
     */
    @RequestMapping("grant")
    public ResponseJson grant(CashCouponGrantParam param) {
        if (!couponProperties.getOpenBackdoor()) {
            return ResponseJson.badReqeuset("测试接口已关闭，如需使用请联系模块负责人").build();
        }

        if (null == param.getUsableStartTime()) {
            param.setUsableStartTime(new Date());
        }
        if (null == param.getUsableEndTime()) {
            param.setUsableEndTime(DateUtils.addField(new Date(), Calendar.DATE, 15));
        }

        return ResponseJson.build(cashCouponService.grantCashCoupon(param));
    }
}
