package com.bxm.localnews.merchant.common.enums;

/**
 * 商家账户动作类型
 *
 * <p>
 * 备注中的流水类型查看：
 * 流水类型 {@link com.bxm.localnews.merchant.common.enums.MerchantBossAccountCashTypeEnum}
 *
 * @author pf.w
 * @date 2020/8/23 11:48
 **/
public enum MerchantBossAccountActionEnum {

    /**
     * 现金优惠券核销成功
     * 给商家增加可提现金额
     * 增加一笔手续费的流水
     */
    CASH_COUPON_CHECKED(6, "cash_coupon_checked"),

    /**
     * 退单打款成功动作       （退单打款失败不做任何处理）
     * <p>
     * 催化产生动作：
     * 1- 增加code=6的一笔退单流水  金额为用户支付金额  金额 A
     * 2- 增加code=7的一笔退单退手续费流水  退给商家  金额 B
     * 3- 增加code=8的一笔退单退佣流水（前提是设置了分佣）  金额 C
     * 4- 商家冻结中金额减去 -(A-(B+C))  及减去该笔订单的实际到账金额
     * 5- 商家总收益-（A-(B+C）及减去该笔订单的实际到账金额
     * 5-update该笔订单中code=1的流水cashflag=1 ----
     * <p>
     * 4- 有分销的话分销给上级的金额要原路返回
     * </p>
     */
    ACCOUNT_ACTION_DRAWBACK(5, "drawback"),

    /**
     * 订单核销成功动作
     * <p>
     * 核销金额(订单实付金额) A    （A为实际付款金额，及减去手续费和分佣后的金额）
     * <p>
     * 催化产生动作：
     * 1-商家可用余额 +A
     * 2-商家冻结中 -A
     * 3-更改该笔订单流水出账状态为 1：已出账 及为已核销 --------
     * </p>
     */
    ACCOUNT_ACTION_VERIFY_CANCEL(4, "verify_cancel"),

    /**
     * 提现打款失败动作
     * <p>
     * 催化产生动作：
     * 1-增加code=3的一笔提现失败流水 资金A
     * 2-商家可用余额 +A
     * 3-商家冻结金额 -A
     * 4-商家提现中金额-A
     * 5-同时update该笔提现中的流水为code=2 and 状态cashflag=1 -----
     * </p>
     */
    ACCOUNT_ACTION_WITHDRAW_FALSE(3, "withdraw_false"),


    /**
     * 提现成功动作
     * <p>
     * 催化产生后续动作：
     * 1-提现金额 A
     * 2-商家冻结中金额 减A
     * 3-商家总资产 减A
     * 4-商家提现中金额 减A
     * 5-商家已提现金额 加A
     * 6-更改该笔提现为code=2流水类型 状态为1 （原来code=5 状态为0）------
     *
     * </p>
     */
    ACCOUNT_ACTION_WITHDRAW_SUCCESS(2, "withdraw_success"),

    /**
     * 提现动作（发起提现，未实际付款，提现资金状态为提现中）
     * <p>
     * 催化产生后续动作：
     * 1-增加code=5的一笔流水  金额：A     状态为0  ------
     * 2-商家可用余额 为 -A
     * 3-商家冻结中金额 +A
     * 4-商家提现中金额 +A
     * </p>
     */
    ACCOUNT_ACTION_WITHDRAW_ING(1, "withdraw_ing"),

    /**
     * 订单付款成功动作
     * <p>
     * 催化产生后续动作：
     * 1-增加code=0的一笔付款流水  金额：A  水出账状态为 0：未出账 及为未核销 ----
     * 2-增加code=1的一笔付款手续费流水  金额：B
     * 3-增加code=4的一笔分销流水，前提是商品设置了分销比例    金额：C
     * 4-商家总收益增加  A-（B+C）
     * 5-商家冻结收益增加 A-（B+C）
     * </p>
     */
    ACCOUNT_ACTION_PAYMENT(0, "payment");


    /**
     * 流水类型
     */
    private int code;

    /**
     * 类型描述
     */
    private String desc;

    MerchantBossAccountActionEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static MerchantBossAccountActionEnum getAction(int code) {
        for (MerchantBossAccountActionEnum enums : MerchantBossAccountActionEnum.values()) {
            if (enums.getCode() == code) {
                return enums;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
