package com.bxm.localnews.merchant.common.event;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.merchant.common.enums.UserActionEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户发起帖子分享
 *
 * @author jieli.xu
 * @date 2020年8月4日 13:55:08
 **/
@EqualsAndHashCode(callSuper = true)
@Data(staticConstructor = "of")
@Accessors(chain = true)
public class ShareForumActionEvent extends UserActionEvent {

    private final UserActionEnum action = UserActionEnum.SHARE_FORUM;

    /**
     * 分享的目标内容
     */
    private Long targetId;

    /**
     * 分享类型 : 主要是新闻和帖子
     */
    private InviteTypeEnum inviteTypeEnum;

}