/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.common.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * @author jieliGG
 * @date 2020/8/25 19:41
 * 商家的相关比率配置
 **/
@ConfigurationProperties("merchant.goods.rate")
@Component
@Data
public class MerchantGoodsRateProperties {
    /**
     * 商家选择VIP折扣时，默认折扣
     * 前提是：vip_discount = 1
     */
    private BigDecimal vipRate = BigDecimal.ZERO;

    /**
     * 分享人是VIP的分成
     */
    private BigDecimal vipUserRate = BigDecimal.ZERO;

    /**
     * 分享人不是VIP的分成
     */
    private BigDecimal userRate = BigDecimal.ZERO;

    /**
     * 分享人是vip时，师傅的比率
     */
    private BigDecimal vipUserInviteRate = BigDecimal.ZERO;

    /**
     * 分享人不是vip时，师傅的比率
     */
    private BigDecimal userInviteRate = BigDecimal.ZERO;

    /**
     * 分享人是vip时，二级师傅的比率
     */
    private BigDecimal vipUserTwoInviteRate = BigDecimal.ZERO;

    /**
     * 分享人不是vip时，师傅的比率
     */
    private BigDecimal userTwoInviteRate = BigDecimal.ZERO;

    /**
     * vip 折扣
     */
    private BigDecimal vipRebate = new BigDecimal("0.95");

    /**
     * 立赚比例
     */
    private BigDecimal profitRebate = new BigDecimal("0.8");

}
