package com.bxm.localnews.merchant.common.service;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.RandomUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;


/**
 * @author liujia
 * @date 2020-10-30 11:30
 **/
@Component
@Slf4j
public class VerificationCodeService {

    private final RedisStringAdapter redisStringAdapter;

    public VerificationCodeService(RedisStringAdapter redisStringAdapter) {
        this.redisStringAdapter = redisStringAdapter;
    }

    public Long gen(KeyGenerator key, Long startNum) {
        int bucketIndex = RandomUtils.nextInt(10, 99);

        KeyGenerator bucketKey = key.copy().appendKey(bucketIndex);

        if (!redisStringAdapter.hasKey(bucketKey)) {
            int randomSeed = (int) (startNum / 100);
            long initValue = bucketIndex * startNum + RandomUtils.nextInt(randomSeed, randomSeed * 10 - 1);
            redisStringAdapter.incrementWithDefault(bucketKey, initValue, 1);
            return initValue;
        }

        Long codeValue = redisStringAdapter.increment(bucketKey);

        // 越界后重试其他bucket
        if (codeValue >= (bucketIndex + 1) * startNum) {
            log.warn("触发越界：{}，生成码：{}", bucketIndex, codeValue);
            return gen(key, startNum);
        }

        return codeValue;
    }
}
