package com.bxm.localnews.merchant.common.utils;

import org.springframework.web.util.UriUtils;

import java.nio.charset.Charset;
import java.util.Map;

/**
 * @author liujia
 * @date 2020-10-31 14:18
 **/
public class URLUtils {
    private URLUtils() {
    }

    public static String buildH5Url(String h5BaseUrl, String pageUrl, Map<String, Object> paramMap) {
        StringBuilder finalUrl = new StringBuilder(h5BaseUrl);
        finalUrl.append(pageUrl);

        if (null != paramMap) {
            finalUrl.append("?");
            paramMap.forEach((key, value) -> {
                finalUrl.append(key).append("=").append(value).append("&");
            });
            finalUrl.deleteCharAt(finalUrl.length() - 1);
        }

        return "wst://web/webDetail?url=" + UriUtils.encode(finalUrl.toString(), Charset.defaultCharset());
    }
}
