package com.bxm.localnews.merchant.common.utils;

import org.hibernate.validator.HibernateValidator;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 验证工具类
 *
 * @author liujia
 * @date 2020-09-24 14:56
 **/
public class ValidateUtils {

    private ValidateUtils() {
    }

    private static Validator getInstance(boolean failFast) {
        return Validation.byProvider(HibernateValidator.class)
                .configure()
                .failFast(failFast)
                .constraintValidatorPayload("zh_CN")
                .buildValidatorFactory()
                .getValidator();
    }

    /**
     * 全验证模式
     *
     * @param obj 验证对象
     * @return 所有错误信息
     */
    public static <T> List<String> valid(T obj) {

        Set<ConstraintViolation<T>> validate = getInstance(false).validate(obj);
        return validate.stream()
                .map(ConstraintViolation::getMessage)
                .collect(Collectors.toList());
    }

    /**
     * 快速校验，有错即返回
     *
     * @param obj 验证对象
     * @return 错误消息
     */
    public static <T> String fastValid(T obj) {
        Set<ConstraintViolation<T>> resultMsg = getInstance(true).validate(obj);

        if (resultMsg.size() > 0) {
            return resultMsg.iterator().next().getMessage();
        }

        return null;
    }
}
