package com.bxm.localnews.merchant.controller;

import com.bxm.localnews.merchant.coupon.service.MerchantCouponService;
import com.bxm.localnews.merchant.coupon.service.RecommendService;
import com.bxm.localnews.merchant.coupon.service.UserCouponService;
import com.bxm.localnews.merchant.dto.coupon.*;
import com.bxm.localnews.merchant.param.coupon.*;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author liujia
 * @date 2020-09-21 15:49
 **/
@Api(tags = "11-14 用户优惠券相关接口", description = "包括用户获取、使用优惠券等")
@RestController
@RequestMapping("{version}/merchant/coupon/user")
public class UserCouponController {

    private final UserCouponService userCouponService;

    private final MerchantCouponService merchantCouponService;

    private final RecommendService recommendService;

    @Autowired
    public UserCouponController(UserCouponService userCouponService,
                                MerchantCouponService merchantCouponService,
                                RecommendService recommendService) {
        this.userCouponService = userCouponService;
        this.merchantCouponService = merchantCouponService;
        this.recommendService = recommendService;
    }

    @ApiOperation("11-14-01 [v1]获取分享优惠券需要的相关参数")
    @GetMapping("public/share")
    @ApiVersion(1)
    public ResponseJson<UserShareCouponDTO> share(UserCouponShareParam param) {
        return ResponseJson.ok(userCouponService.getCouponShareInfo(param));
    }

    @ApiOperation(value = "11-14-02 [v1]获取商户下的所有可优惠券与可领取状态", notes = "默认会返回当前商户的所有可领取优惠券")
    @GetMapping("list")
    @ApiVersion(1)
    public ResponseJson<List<UserCouponInfoWithReceiveDTO>> getMerchantCoupon(UserMerchantCouponParam param) {
        return ResponseJson.ok(merchantCouponService.getRecommendMerchantCoupons(param));
    }

    @ApiOperation(value = "11-14-03 [v1]用户领取优惠券", notes = "领取优惠券，包括关注并领取")
    @PostMapping("receive")
    @ApiVersion(1)
    public ResponseJson receive(@RequestBody UserReceiveCouponParam param) {
        return ResponseJson.build(userCouponService.execReceiveCoupon(param));
    }

    @ApiOperation(value = "11-14-04 [v1]获取不同状态的用户领取的优惠券", notes = "查询不同状态的用户领取的优惠券")
    @GetMapping("security/receive/list")
    @ApiVersion(1)
    public ResponseJson<PageWarper<UserCouponDetailDTO>> receiveList(UserCouponStatusPageParam param) {
        return ResponseJson.ok(userCouponService.queryUserCouponByPage(param));
    }

    @ApiOperation(value = "11-14-05 [v1]根据用户优惠券ID获取优惠券的核销信息", notes = "如果返回状态码不正确，说明无核销信息，提示对应的错误消息")
    @GetMapping("check/info")
    @ApiVersion(1)
    public ResponseJson<UserCouponCheckInfoDTO> getCheckInfo(UserCouponCheckParam param) {
        UserCouponCheckInfoDTO userCouponCheckInfo = userCouponService.getUserCouponCheckInfo(param);

        if (null == userCouponCheckInfo) {
            return ResponseJson.badReqeuset("优惠券不存在").build();
        }

        return ResponseJson.ok(userCouponCheckInfo);
    }

    @ApiOperation(value = "11-14-06 [v1]下单时，推荐一张优惠券", notes = "如果返回为空，则说明用户无可用的优惠券")
    @GetMapping("recommend")
    @ApiVersion(1)
    public ResponseJson<UserRecommendCouponDTO> recommendCoupon(BaseMerchantCouponParam param) {
        return ResponseJson.ok(recommendService.recommendMaxCoupon(param));
    }

    @ApiOperation(value = "11-14-07 [v1]下单时可选的优惠券列表")
    @GetMapping("recommend/list")
    @ApiVersion(1)
    public ResponseJson<List<UserRecommendCouponDetailDTO>> recommendCouponList(BaseMerchantCouponParam param) {
        return ResponseJson.ok(recommendService.recommendCouponList(param));
    }
}









