package com.bxm.localnews.merchant.dto.coupon;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author liujia
 * @date 2020-09-21 21:51
 **/
@Data
public class ManageCouponDetailDTO {
    @ApiModelProperty("是否有金额使用门槛")
    private Boolean conditionAmount;

    @ApiModelProperty("优惠券门槛金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("优惠券优惠金额")
    private BigDecimal discountAmount;

    @ApiModelProperty("库存数量")
    private Integer totalQuantity;

    @ApiModelProperty("单人可领取的最大数量，默认为1")
    private Integer maxNum;

    @ApiModelProperty("是否需要关注")
    private Boolean conditionFollow;

    @ApiModelProperty("优惠券可用起始时间")
    private Date usableStartDate;

    @ApiModelProperty("优惠券可用截止时间")
    private Date usableEndDate;

    @ApiModelProperty("使用规则")
    private String ruleRemark;

    @ApiModelProperty("分享文案")
    private String shareTips;

    @ApiModelProperty(value = "优惠券ID")
    private Long couponId;

    @ApiModelProperty(value = "当前商户ID", required = true)
    private Long merchantId;

    @ApiModelProperty(value = "优惠券类型", hidden = true)
    private Integer type;

    @ApiModelProperty(value = "优惠券来源", hidden = true)
    private Integer source;

    @ApiModelProperty(value = "优惠券状态", hidden = true)
    private Integer status;
}
