package com.bxm.localnews.merchant.dto.coupon;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

import static com.bxm.localnews.merchant.common.constant.AppCommonStatus.COMMON_DATE_FORMAT;

/**
 * @author liujia
 * @date 2020-09-21 21:26
 **/
@Data
@ApiModel(description = "管理后台的表格显示的数据")
public class ManageCouponItemDTO {
    @ApiModelProperty("优惠券ID")
    private Long couponId;

    @ApiModelProperty("优惠券所属商户名称")
    private String merchantName;

    @ApiModelProperty("优惠券状态的中文显示")
    private String statusLabel;

    @ApiModelProperty("优惠券当前状态,1:可领取状态，2：未开始，3：已领完，97：已过期，98：已停用,99：已作废。" +
            "除已作废状态外，均可作废" +
            "除已作废、已停用状态外，均可停用")
    private Integer status;

    @ApiModelProperty("使用门槛（条件）的金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("劵面额")
    private BigDecimal discount;

    @ApiModelProperty("优惠券可用时间-起始时间(已格式化)")
    @JsonFormat(pattern = COMMON_DATE_FORMAT)
    private Date usableStartTime;

    @ApiModelProperty("优惠券可用时间-截止时间(已格式化)")
    @JsonFormat(pattern = COMMON_DATE_FORMAT)
    private Date usableEndTime;

    @ApiModelProperty("领取总数")
    private Integer receiveQuantity;

    @ApiModelProperty("领取人数")
    private Integer receiveUserQuantify;

    @ApiModelProperty("使用总数")
    private Integer useQuantity;

    @ApiModelProperty("使用人数")
    private Integer useUserQuantity;

    @ApiModelProperty("库存数量")
    private Integer stock;
}
