package com.bxm.localnews.merchant.param.coupon;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author liujia
 * @date 2020-09-21 19:43
 **/
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "用户不同状态的优惠券列表分页查询参数")
@Data
public class UserCouponStatusPageParam extends PageParam {

    @ApiModelProperty("当前用户ID")
    private Long userId;

    @ApiModelProperty("用户优惠券状态，1：未使用，2：已使用，3：已失效")
    private Integer status;

    @ApiModelProperty(value = "查询状态的子状态", hidden = true)
    private List<Integer> subStatus;
}
